/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.context.properties.bind.PlaceholdersResolver;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.PropertyPlaceholderHandler;

public class PropertySourcesPlaceholdersResolver
implements PlaceholdersResolver {
    @Nullable
    private final Iterable<PropertySource<?>> sources;
    private final PropertyPlaceholderHandler helper;

    public PropertySourcesPlaceholdersResolver(Environment environment) {
        this((Iterable<PropertySource<?>>)PropertySourcesPlaceholdersResolver.getSources(environment), null);
    }

    public PropertySourcesPlaceholdersResolver(Iterable<PropertySource<?>> sources) {
        this(sources, null);
    }

    public PropertySourcesPlaceholdersResolver(@Nullable Iterable<PropertySource<?>> sources, @Nullable PropertyPlaceholderHandler helper) {
        this.sources = sources;
        this.helper = helper != null ? helper : new PropertyPlaceholderHandler("${", "}", ":", true);
    }

    @Override
    public Object resolvePlaceholders(Object value) {
        if (value instanceof String) {
            return this.helper.replacePlaceholders((String)value, this::resolvePlaceholder);
        }
        return value;
    }

    @Nullable
    protected String resolvePlaceholder(String placeholder) {
        if (this.sources != null) {
            for (PropertySource<?> source : this.sources) {
                Object value = source.getProperty(placeholder);
                if (value == null) continue;
                return String.valueOf(value);
            }
        }
        return null;
    }

    private static PropertySources getSources(Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"Environment must be a ConfigurableEnvironment");
        return ((ConfigurableEnvironment)environment).getPropertySources();
    }
}

