/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.beans.factory.annotation.Autowired;
import cn.taketoday.context.properties.bind.BindConstructorProvider;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.ConstructorBinding;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;

class DefaultBindConstructorProvider
implements BindConstructorProvider {
    DefaultBindConstructorProvider() {
    }

    @Override
    public Constructor<?> getBindConstructor(Bindable<?> bindable, boolean isNestedConstructorBinding) {
        Constructors constructors = Constructors.getConstructors(bindable.getType().resolve(), isNestedConstructorBinding);
        if (constructors.getBind() != null && constructors.isDeducedBindConstructor() && bindable.getValue() != null && bindable.getValue().get() != null) {
            return null;
        }
        return constructors.getBind();
    }

    @Override
    public Constructor<?> getBindConstructor(Class<?> type, boolean isNestedConstructorBinding) {
        Constructors constructors = Constructors.getConstructors(type, isNestedConstructorBinding);
        return constructors.getBind();
    }

    static final class Constructors {
        private static final Constructors NONE = new Constructors(false, null, false);
        private final boolean hasAutowired;
        @Nullable
        private final Constructor<?> bind;
        private final boolean deducedBindConstructor;

        private Constructors(boolean hasAutowired, @Nullable Constructor<?> bind, boolean deducedBindConstructor) {
            this.hasAutowired = hasAutowired;
            this.bind = bind;
            this.deducedBindConstructor = deducedBindConstructor;
        }

        boolean hasAutowired() {
            return this.hasAutowired;
        }

        @Nullable
        Constructor<?> getBind() {
            return this.bind;
        }

        boolean isDeducedBindConstructor() {
            return this.deducedBindConstructor;
        }

        static Constructors getConstructors(@Nullable Class<?> type, boolean isNestedConstructorBinding) {
            if (type == null) {
                return NONE;
            }
            boolean hasAutowiredConstructor = Constructors.isAutowiredPresent(type);
            Constructor<?>[] candidates = Constructors.getCandidateConstructors(type);
            MergedAnnotations[] candidateAnnotations = Constructors.getAnnotations(candidates);
            boolean deducedBindConstructor = false;
            Constructor<?> bind = Constructors.getConstructorBindingAnnotated(type, candidates, candidateAnnotations);
            if (bind == null && !hasAutowiredConstructor) {
                bind = Constructors.deduceBindConstructor(type, candidates);
                boolean bl = deducedBindConstructor = bind != null;
            }
            if (bind != null || isNestedConstructorBinding) {
                Assert.state((!hasAutowiredConstructor ? 1 : 0) != 0, () -> type.getName() + " declares @ConstructorBinding and @Autowired constructor");
            }
            return new Constructors(hasAutowiredConstructor, bind, deducedBindConstructor);
        }

        private static boolean isAutowiredPresent(Class<?> type) {
            if (Stream.of(type.getDeclaredConstructors()).map(MergedAnnotations::from).anyMatch(annotations -> annotations.isPresent(Autowired.class))) {
                return true;
            }
            Class userClass = ClassUtils.getUserClass(type);
            return userClass != type && Constructors.isAutowiredPresent(userClass);
        }

        private static Constructor<?>[] getCandidateConstructors(Class<?> type) {
            if (Constructors.isInnerClass(type)) {
                return new Constructor[0];
            }
            return (Constructor[])Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> Constructors.isNonSynthetic(constructor, type)).toArray(Constructor[]::new);
        }

        private static boolean isInnerClass(Class<?> type) {
            try {
                return type.getDeclaredField("this$0").isSynthetic();
            }
            catch (NoSuchFieldException ex) {
                return false;
            }
        }

        private static boolean isNonSynthetic(Constructor<?> constructor, Class<?> type) {
            return !constructor.isSynthetic();
        }

        private static MergedAnnotations[] getAnnotations(Constructor<?>[] candidates) {
            MergedAnnotations[] candidateAnnotations = new MergedAnnotations[candidates.length];
            for (int i = 0; i < candidates.length; ++i) {
                candidateAnnotations[i] = MergedAnnotations.from(candidates[i], (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
            }
            return candidateAnnotations;
        }

        @Nullable
        private static Constructor<?> getConstructorBindingAnnotated(Class<?> type, Constructor<?>[] candidates, MergedAnnotations[] mergedAnnotations) {
            Constructor<?> result = null;
            for (int i = 0; i < candidates.length; ++i) {
                if (!mergedAnnotations[i].isPresent(ConstructorBinding.class)) continue;
                if (candidates[i].getParameterCount() <= 0) {
                    throw new IllegalStateException(type.getName() + " declares @ConstructorBinding on a no-args constructor");
                }
                if (result != null) {
                    throw new IllegalStateException(type.getName() + " has more than one @ConstructorBinding constructor");
                }
                result = candidates[i];
            }
            return result;
        }

        @Nullable
        private static Constructor<?> deduceBindConstructor(Class<?> type, Constructor<?>[] candidates) {
            if (candidates.length == 1 && candidates[0].getParameterCount() > 0) {
                if (type.isMemberClass() && Modifier.isPrivate(candidates[0].getModifiers())) {
                    return null;
                }
                return candidates[0];
            }
            Constructor<?> result = null;
            for (Constructor<?> candidate : candidates) {
                if (Modifier.isPrivate(candidate.getModifiers())) continue;
                if (result != null) {
                    return null;
                }
                result = candidate;
            }
            return result != null && result.getParameterCount() > 0 ? result : null;
        }
    }
}

