/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.style.ToStringBuilder;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.function.SingletonSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public final class Bindable<T> {
    private static final EnumSet<BindRestriction> NO_BIND_RESTRICTIONS = EnumSet.noneOf(BindRestriction.class);
    private final ResolvableType type;
    private final ResolvableType boxedType;
    @Nullable
    private final Supplier<T> value;
    private final Annotation[] annotations;
    private final EnumSet<BindRestriction> bindRestrictions;

    private Bindable(ResolvableType type, ResolvableType boxedType, @Nullable Supplier<T> value, Annotation[] annotations, EnumSet<BindRestriction> bindRestrictions) {
        this.type = type;
        this.boxedType = boxedType;
        this.value = value;
        this.annotations = annotations;
        this.bindRestrictions = bindRestrictions;
    }

    public ResolvableType getType() {
        return this.type;
    }

    public ResolvableType getBoxedType() {
        return this.boxedType;
    }

    @Nullable
    public Supplier<T> getValue() {
        return this.value;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        for (Annotation annotation : this.annotations) {
            if (!type.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    public boolean hasBindRestriction(BindRestriction bindRestriction) {
        return this.bindRestrictions.contains((Object)bindRestriction);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bindable other = (Bindable)obj;
        return Objects.equals(this.type.resolve(), other.type.resolve()) && Objects.equals(this.bindRestrictions, other.bindRestrictions) && ObjectUtils.nullSafeEquals((Object)this.annotations, (Object)other.annotations);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.type);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object[])this.annotations);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.bindRestrictions);
        return result;
    }

    public String toString() {
        ToStringBuilder creator = new ToStringBuilder((Object)this);
        creator.append("type", (Object)this.type);
        creator.append("value", (Object)(this.value != null ? "provided" : "none"));
        creator.append("annotations", (Object)this.annotations);
        return creator.toString();
    }

    public Bindable<T> withAnnotations(Annotation ... annotations) {
        return new Bindable<T>(this.type, this.boxedType, this.value, annotations != null ? annotations : Constant.EMPTY_ANNOTATIONS, NO_BIND_RESTRICTIONS);
    }

    public Bindable<T> withExistingValue(@Nullable T existingValue) {
        if (existingValue != null && !this.type.isArray() && !this.boxedType.resolve().isInstance(existingValue)) {
            throw new IllegalArgumentException("ExistingValue must be an instance of " + this.type);
        }
        SingletonSupplier value = existingValue != null ? SingletonSupplier.valueOf(existingValue) : null;
        return new Bindable<T>(this.type, this.boxedType, value, this.annotations, this.bindRestrictions);
    }

    public Bindable<T> withSuppliedValue(Supplier<T> suppliedValue) {
        return new Bindable<T>(this.type, this.boxedType, suppliedValue, this.annotations, this.bindRestrictions);
    }

    public Bindable<T> withBindRestrictions(BindRestriction ... additionalRestrictions) {
        EnumSet<BindRestriction> bindRestrictions = EnumSet.copyOf(this.bindRestrictions);
        CollectionUtils.addAll(bindRestrictions, (Object[])additionalRestrictions);
        return new Bindable<T>(this.type, this.boxedType, this.value, this.annotations, bindRestrictions);
    }

    public static <T> Bindable<T> ofInstance(T instance) {
        Assert.notNull(instance, (String)"Instance must not be null");
        Class<?> type = instance.getClass();
        return Bindable.of(type).withExistingValue(instance);
    }

    public static <T> Bindable<T> of(Class<T> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return Bindable.of(ResolvableType.fromClass(type));
    }

    public static <E> Bindable<List<E>> listOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.fromClassWithGenerics(List.class, (Class[])new Class[]{elementType}));
    }

    public static <E> Bindable<Set<E>> setOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.fromClassWithGenerics(Set.class, (Class[])new Class[]{elementType}));
    }

    public static <K, V> Bindable<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return Bindable.of(ResolvableType.fromClassWithGenerics(Map.class, (Class[])new Class[]{keyType, valueType}));
    }

    public static <T> Bindable<T> of(ResolvableType type) {
        Assert.notNull((Object)type, (String)"Type must not be null");
        ResolvableType boxedType = Bindable.box(type);
        return new Bindable<T>(type, boxedType, null, Constant.EMPTY_ANNOTATIONS, NO_BIND_RESTRICTIONS);
    }

    private static ResolvableType box(ResolvableType type) {
        Class resolved = type.resolve();
        if (resolved != null && resolved.isPrimitive()) {
            Object array = Array.newInstance(resolved, 1);
            Class<?> wrapperType = Array.get(array, 0).getClass();
            return ResolvableType.fromClass(wrapperType);
        }
        if (resolved != null && resolved.isArray()) {
            return ResolvableType.fromArrayComponent((ResolvableType)Bindable.box(type.getComponentType()));
        }
        return type;
    }

    public static enum BindRestriction {
        NO_DIRECT_PROPERTY;

    }
}

