/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class BindResult<T> {
    private static final BindResult<?> UNBOUND = new BindResult<Object>(null);
    @Nullable
    private final T value;

    private BindResult(@Nullable T value) {
        this.value = value;
    }

    public T get() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value bound");
        }
        return this.value;
    }

    public boolean isBound() {
        return this.value != null;
    }

    public void ifBound(Consumer<? super T> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null");
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public <U> BindResult<U> map(Function<? super T, ? extends U> mapper) {
        Assert.notNull(mapper, (String)"Mapper must not be null");
        return BindResult.of(this.value != null ? (T)mapper.apply((T)this.value) : null);
    }

    @Nullable
    public T orElse(@Nullable T other) {
        return this.value != null ? this.value : other;
    }

    public T orRequired(T other) {
        if (this.value != null) {
            return this.value;
        }
        Assert.state((other != null ? 1 : 0) != 0, (String)"other value is required");
        return other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.value, ((BindResult)obj).value);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.value);
    }

    static <T> BindResult<T> of(@Nullable T value) {
        if (value == null) {
            return UNBOUND;
        }
        return new BindResult<T>(value);
    }
}

