/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.source.ConfigurationProperty;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginProvider;

public class BindException
extends RuntimeException
implements OriginProvider {
    private final Bindable<?> target;
    private final ConfigurationProperty property;
    private final ConfigurationPropertyName name;

    BindException(ConfigurationPropertyName name, Bindable<?> target, ConfigurationProperty property, Throwable cause) {
        super(BindException.buildMessage(name, target), cause);
        this.name = name;
        this.target = target;
        this.property = property;
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Bindable<?> getTarget() {
        return this.target;
    }

    public ConfigurationProperty getProperty() {
        return this.property;
    }

    @Override
    public Origin getOrigin() {
        return Origin.from(this.name);
    }

    private static String buildMessage(ConfigurationPropertyName name, Bindable<?> target) {
        StringBuilder message = new StringBuilder();
        message.append("Failed to bind properties");
        message.append((String)(name != null ? " under '" + name + "'" : ""));
        message.append(" to ").append(target.getType());
        return message.toString();
    }
}

