/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.PropertyEditorRegistry;
import cn.taketoday.beans.SimpleTypeConverter;
import cn.taketoday.beans.propertyeditors.CustomBooleanEditor;
import cn.taketoday.beans.propertyeditors.CustomNumberEditor;
import cn.taketoday.beans.propertyeditors.FileEditor;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.ConversionException;
import cn.taketoday.core.conversion.ConversionFailedException;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.ConverterNotFoundException;
import cn.taketoday.core.conversion.ConverterRegistry;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.core.conversion.support.GenericConversionService;
import cn.taketoday.format.support.ApplicationConversionService;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

final class BindConverter {
    @Nullable
    private static BindConverter sharedInstance;
    private final List<ConversionService> delegates;

    private BindConverter(@Nullable List<ConversionService> conversionServices, @Nullable Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        ArrayList<TypeConverterConversionService> delegates = new ArrayList<TypeConverterConversionService>();
        delegates.add(new TypeConverterConversionService(propertyEditorInitializer));
        boolean hasApplication = false;
        if (CollectionUtils.isNotEmpty(conversionServices)) {
            for (ConversionService conversionService : conversionServices) {
                delegates.add((TypeConverterConversionService)conversionService);
                hasApplication = hasApplication || conversionService instanceof ApplicationConversionService;
            }
        }
        if (!hasApplication) {
            delegates.add((TypeConverterConversionService)ApplicationConversionService.getSharedInstance());
        }
        this.delegates = Collections.unmodifiableList(delegates);
    }

    boolean canConvert(Object source, ResolvableType targetType, Annotation ... targetAnnotations) {
        return this.canConvert(TypeDescriptor.fromObject((Object)source), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    private boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (ConversionService service : this.delegates) {
            if (!service.canConvert(sourceType, targetType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    <T> T convert(Object source, Bindable<T> target) {
        return this.convert(source, target.getType(), target.getAnnotations());
    }

    @Nullable
    <T> T convert(@Nullable Object source, ResolvableType targetType, Annotation ... targetAnnotations) {
        if (source == null) {
            return null;
        }
        return (T)this.convert(source, TypeDescriptor.fromObject((Object)source), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    @Nullable
    private Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Object failure = null;
        for (ConversionService delegate : this.delegates) {
            try {
                if (!delegate.canConvert(sourceType, targetType)) continue;
                return delegate.convert(source, sourceType, targetType);
            }
            catch (ConversionException ex) {
                if (failure != null || !(ex instanceof ConversionFailedException)) continue;
                failure = ex;
            }
        }
        throw failure != null ? failure : new ConverterNotFoundException(sourceType, targetType);
    }

    static BindConverter get(@Nullable List<ConversionService> conversionServices, @Nullable Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        boolean sharedApplicationConversionService;
        boolean bl = sharedApplicationConversionService = conversionServices == null || conversionServices.size() == 1 && conversionServices.get(0) == ApplicationConversionService.getSharedInstance();
        if (propertyEditorInitializer == null && sharedApplicationConversionService) {
            return BindConverter.getSharedInstance();
        }
        return new BindConverter(conversionServices, propertyEditorInitializer);
    }

    private static BindConverter getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BindConverter(null, null);
        }
        return sharedInstance;
    }

    private static class TypeConverterConversionService
    extends GenericConversionService {
        TypeConverterConversionService(@Nullable Consumer<PropertyEditorRegistry> initializer) {
            this.addConverter((GenericConverter)new TypeConverterConverter(initializer));
            ApplicationConversionService.addDelimitedStringConverters((ConverterRegistry)this);
        }

        public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
            TypeDescriptor descriptor;
            if (targetType.isArray() && (descriptor = targetType.getElementDescriptor()) != null && descriptor.isPrimitive()) {
                return false;
            }
            return super.canConvert(sourceType, targetType);
        }
    }

    private static class ResolvableTypeDescriptor
    extends TypeDescriptor {
        ResolvableTypeDescriptor(ResolvableType resolvableType, Annotation[] annotations) {
            super(resolvableType, null, annotations);
        }
    }

    private static class TypeConverterConverter
    implements ConditionalGenericConverter {
        private static final Set<Class<?>> EXCLUDED_EDITORS = Set.of(CustomNumberEditor.class, CustomBooleanEditor.class, FileEditor.class);
        @Nullable
        private final Consumer<PropertyEditorRegistry> initializer;
        private final SimpleTypeConverter matchesOnlyTypeConverter;

        TypeConverterConverter(@Nullable Consumer<PropertyEditorRegistry> initializer) {
            this.initializer = initializer;
            this.matchesOnlyTypeConverter = this.createTypeConverter();
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object.class));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            Class type = targetType.getType();
            if (type == null || type == Object.class || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
                return false;
            }
            PropertyEditor editor = this.matchesOnlyTypeConverter.getDefaultEditor(type);
            if (editor == null) {
                editor = this.matchesOnlyTypeConverter.findCustomEditor(type, null);
            }
            if (editor == null && String.class != type) {
                editor = BeanUtils.findEditorByConvention((Class)type);
            }
            return editor != null && !EXCLUDED_EDITORS.contains(editor.getClass());
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.createTypeConverter().convertIfNecessary(source, targetType.getType());
        }

        private SimpleTypeConverter createTypeConverter() {
            SimpleTypeConverter typeConverter = new SimpleTypeConverter();
            if (this.initializer != null) {
                this.initializer.accept((PropertyEditorRegistry)typeConverter);
            }
            return typeConverter;
        }
    }
}

