/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.bind;

import cn.taketoday.context.properties.bind.AggregateElementBinder;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.Binder;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.lang.Nullable;
import java.util.function.Supplier;

abstract class AggregateBinder<T> {
    private final Binder.Context context;

    AggregateBinder(Binder.Context context) {
        this.context = context;
    }

    protected abstract boolean isAllowRecursiveBinding(@Nullable ConfigurationPropertySource var1);

    @Nullable
    final Object bind(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder) {
        Object result = this.bindAggregate(name, target, elementBinder);
        Supplier<?> value = target.getValue();
        if (result == null || value == null) {
            return result;
        }
        return this.merge(value, result);
    }

    @Nullable
    protected abstract Object bindAggregate(ConfigurationPropertyName var1, Bindable<?> var2, AggregateElementBinder var3);

    protected abstract T merge(Supplier<T> var1, T var2);

    protected final Binder.Context getContext() {
        return this.context;
    }

    protected static class AggregateSupplier<T> {
        private final Supplier<T> supplier;
        @Nullable
        private T supplied;

        public AggregateSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() {
            if (this.supplied == null) {
                this.supplied = this.supplier.get();
            }
            return this.supplied;
        }

        public boolean wasSupplied() {
            return this.supplied != null;
        }
    }
}

