/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.support.PropertySourcesPlaceholderConfigurer;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import java.util.Map;

class PropertySourcesDeducer {
    private static final Logger logger = LoggerFactory.getLogger(PropertySourcesDeducer.class);
    private final ApplicationContext context;

    PropertySourcesDeducer(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    PropertySources getPropertySources() {
        PropertySourcesPlaceholderConfigurer configurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (configurer != null) {
            return configurer.getAppliedPropertySources();
        }
        PropertySources sources = this.extractEnvironmentPropertySources();
        Assert.state((sources != null ? 1 : 0) != 0, (String)"Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
        return sources;
    }

    @Nullable
    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        Map beans = this.context.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
        if (beans.size() == 1) {
            return (PropertySourcesPlaceholderConfigurer)CollectionUtils.firstElement(beans.values());
        }
        if (beans.size() > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple PropertySourcesPlaceholderConfigurer beans registered {}, falling back to Environment", beans.keySet());
        }
        return null;
    }

    @Nullable
    private PropertySources extractEnvironmentPropertySources() {
        Environment environment = this.context.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)environment).getPropertySources();
        }
        return null;
    }
}

