/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.context.properties.BoundConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationPropertiesBeanRegistrar;
import cn.taketoday.context.properties.ConfigurationPropertiesBindingPostProcessor;
import cn.taketoday.context.properties.EnableConfigurationProperties;
import cn.taketoday.core.Conventions;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.validation.beanvalidation.MethodValidationExcludeFilter;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class EnableConfigurationPropertiesRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String METHOD_VALIDATION_EXCLUDE_FILTER_BEAN_NAME = Conventions.getQualifiedAttributeName(EnableConfigurationPropertiesRegistrar.class, (String)"methodValidationExcludeFilter");

    EnableConfigurationPropertiesRegistrar() {
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata metadata, BootstrapContext context) {
        BeanDefinitionRegistry registry = context.getRegistry();
        EnableConfigurationPropertiesRegistrar.registerInfrastructureBeans(registry);
        EnableConfigurationPropertiesRegistrar.registerMethodValidationExcludeFilter(registry);
        ConfigurationPropertiesBeanRegistrar beanRegistrar = new ConfigurationPropertiesBeanRegistrar(context);
        for (Class<?> type : this.getTypes(metadata)) {
            beanRegistrar.register(type);
        }
    }

    private Set<Class<?>> getTypes(AnnotationMetadata metadata) {
        return metadata.getAnnotations().stream(EnableConfigurationProperties.class).flatMap(annotation -> Arrays.stream(annotation.getClassValueArray())).filter(Predicate.isEqual(Void.TYPE).negate()).collect(Collectors.toSet());
    }

    static void registerInfrastructureBeans(BeanDefinitionRegistry registry) {
        ConfigurationPropertiesBindingPostProcessor.register(registry);
        BoundConfigurationProperties.register(registry);
    }

    static void registerMethodValidationExcludeFilter(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(METHOD_VALIDATION_EXCLUDE_FILTER_BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(MethodValidationExcludeFilter.class);
            definition.setRole(2);
            definition.setInstanceSupplier(() -> MethodValidationExcludeFilter.byAnnotation(ConfigurationProperties.class));
            registry.registerBeanDefinition(METHOD_VALIDATION_EXCLUDE_FILTER_BEAN_NAME, (BeanDefinition)definition);
        }
    }
}

