/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.annotation.BeanFactoryAnnotationUtils;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.FormatterRegistry;
import cn.taketoday.format.support.ApplicationConversionService;
import cn.taketoday.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ConversionServiceDeducer {
    private final ApplicationContext context;

    ConversionServiceDeducer(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Nullable
    List<ConversionService> getConversionServices() {
        if (this.hasUserDefinedConfigurationServiceBean()) {
            return Collections.singletonList((ConversionService)this.context.getBean("conversionService", ConversionService.class));
        }
        if (this.context instanceof ConfigurableApplicationContext) {
            return this.getConversionServices((ConfigurableApplicationContext)this.context);
        }
        return null;
    }

    private List<ConversionService> getConversionServices(ConfigurableApplicationContext applicationContext) {
        ConverterBeans converterBeans;
        ArrayList<ConversionService> conversionServices = new ArrayList<ConversionService>();
        if (applicationContext.getBeanFactory().getConversionService() != null) {
            conversionServices.add(applicationContext.getBeanFactory().getConversionService());
        }
        if (!(converterBeans = new ConverterBeans(applicationContext)).isEmpty()) {
            ApplicationConversionService beansConverterService = new ApplicationConversionService();
            converterBeans.addTo(beansConverterService);
            conversionServices.add((ConversionService)beansConverterService);
        }
        return conversionServices;
    }

    private boolean hasUserDefinedConfigurationServiceBean() {
        String beanName = "conversionService";
        return this.context.containsBean(beanName) && this.context.getAutowireCapableBeanFactory().isTypeMatch(beanName, ConversionService.class);
    }

    private static class ConverterBeans {
        private final List<Converter> converters;
        private final List<GenericConverter> genericConverters;
        private final List<Formatter> formatters;

        ConverterBeans(ConfigurableApplicationContext applicationContext) {
            ConfigurableBeanFactory beanFactory = applicationContext.getBeanFactory();
            this.converters = this.beans(Converter.class, (BeanFactory)beanFactory);
            this.genericConverters = this.beans(GenericConverter.class, (BeanFactory)beanFactory);
            this.formatters = this.beans(Formatter.class, (BeanFactory)beanFactory);
        }

        private <T> List<T> beans(Class<T> type, BeanFactory beanFactory) {
            return new ArrayList(BeanFactoryAnnotationUtils.qualifiedBeansOfType((BeanFactory)beanFactory, type, (String)"cn.taketoday.context.properties.ConfigurationPropertiesBinding").values());
        }

        boolean isEmpty() {
            return this.converters.isEmpty() && this.genericConverters.isEmpty() && this.formatters.isEmpty();
        }

        void addTo(FormatterRegistry registry) {
            for (Converter converter : this.converters) {
                registry.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                registry.addConverter(genericConverter);
            }
            for (Formatter formatter : this.formatters) {
                registry.addFormatter(formatter);
            }
        }
    }
}

