/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ClassPathScanningCandidateComponentProvider;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.context.annotation.config.TypeExcludeFilter;
import cn.taketoday.context.properties.ConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationPropertiesBeanRegistrar;
import cn.taketoday.context.properties.ConfigurationPropertiesScan;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotationSelectors;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.filter.AnnotationTypeFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Assert;
import cn.taketoday.stereotype.Component;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;

class ConfigurationPropertiesScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private final Environment environment;
    private final ResourceLoader resourceLoader;

    ConfigurationPropertiesScanRegistrar(Environment environment, ResourceLoader resourceLoader) {
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importMetadata, BootstrapContext context) {
        Set<String> packagesToScan = this.getPackagesToScan(importMetadata);
        this.scan(context, packagesToScan);
    }

    private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        MergedAnnotation attributes = metadata.getAnnotations().get(ConfigurationPropertiesScan.class, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        Assert.state((boolean)attributes.isPresent(), (String)"ConfigurationPropertiesScan not present");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet packagesToScan = CollectionUtils.newLinkedHashSet((Object[])basePackages);
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            packagesToScan.add(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        packagesToScan.removeIf(Predicate.not(StringUtils::hasText));
        return packagesToScan;
    }

    private void scan(BootstrapContext context, Set<String> packages) {
        ConfigurationPropertiesBeanRegistrar registrar = new ConfigurationPropertiesBeanRegistrar(context);
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner(context);
        for (String basePackage : packages) {
            try {
                scanner.scanCandidateComponents(basePackage, (metadataReader, factory) -> this.register(registrar, metadataReader));
            }
            catch (IOException e) {
                throw new IllegalStateException("ConfigurationProperties scanning failed", e);
            }
        }
    }

    private ClassPathScanningCandidateComponentProvider getScanner(BootstrapContext context) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false, this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ConfigurationProperties.class));
        TypeExcludeFilter typeExcludeFilter = new TypeExcludeFilter();
        typeExcludeFilter.setBeanFactory(context.getBeanFactory());
        scanner.addExcludeFilter(typeExcludeFilter);
        return scanner;
    }

    private void register(ConfigurationPropertiesBeanRegistrar registrar, MetadataReader reader) throws LinkageError {
        Class objectClass;
        AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
        if (!this.isComponent(annotationMetadata) && (objectClass = ClassUtils.load((String)annotationMetadata.getClassName(), null)) != null) {
            registrar.register(objectClass);
        }
    }

    private boolean isComponent(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.isAnnotated(Component.class.getName());
    }
}

