/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.validation.Errors;
import cn.taketoday.validation.MessageInterpolatorFactory;
import cn.taketoday.validation.Validator;
import cn.taketoday.validation.beanvalidation.LocalValidatorFactoryBean;

final class ConfigurationPropertiesJsr303Validator
implements Validator {
    private static final String[] VALIDATOR_CLASSES = new String[]{"jakarta.validation.Validator", "jakarta.validation.ValidatorFactory", "jakarta.validation.bootstrap.GenericBootstrap"};
    private final Delegate delegate;

    ConfigurationPropertiesJsr303Validator(ApplicationContext applicationContext) {
        this.delegate = new Delegate(applicationContext);
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.delegate.supports(type);
    }

    @Override
    public void validate(Object target, Errors errors) {
        this.delegate.validate(target, errors);
    }

    static boolean isJsr303Present(ApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        for (String validatorClass : VALIDATOR_CLASSES) {
            if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)classLoader)) continue;
            return false;
        }
        return true;
    }

    private static class Delegate
    extends LocalValidatorFactoryBean {
        Delegate(ApplicationContext applicationContext) {
            this.setApplicationContext(applicationContext);
            this.setMessageInterpolator(new MessageInterpolatorFactory(applicationContext).get());
            this.afterPropertiesSet();
        }
    }
}

