/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.properties.ConfigurationPropertiesBean;
import cn.taketoday.context.properties.ConfigurationPropertiesBindException;
import cn.taketoday.context.properties.ConfigurationPropertiesBinder;
import cn.taketoday.core.PriorityOrdered;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;

public class ConfigurationPropertiesBindingPostProcessor
implements InitializationBeanPostProcessor,
PriorityOrdered,
ApplicationContextAware,
InitializingBean {
    public static final String BEAN_NAME = ConfigurationPropertiesBindingPostProcessor.class.getName();
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry registry;
    private ConfigurationPropertiesBinder binder;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.registry = (BeanDefinitionRegistry)this.applicationContext.getAutowireCapableBeanFactory();
        this.binder = ConfigurationPropertiesBinder.get((BeanFactory)this.applicationContext);
    }

    public int getOrder() {
        return -2147483647;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.hasBoundValueObject(beanName)) {
            this.bind(ConfigurationPropertiesBean.get(this.applicationContext, bean, beanName));
        }
        return bean;
    }

    private boolean hasBoundValueObject(String beanName) {
        return this.registry.containsBeanDefinition(beanName) && ConfigurationPropertiesBean.BindMethod.VALUE_OBJECT.equals(this.registry.getBeanDefinition(beanName).getAttribute(ConfigurationPropertiesBean.BindMethod.class.getName()));
    }

    private void bind(@Nullable ConfigurationPropertiesBean bean) {
        if (bean == null) {
            return;
        }
        if (bean.getBindMethod() != ConfigurationPropertiesBean.BindMethod.JAVA_BEAN) {
            throw new IllegalStateException("Cannot bind @ConfigurationProperties for bean '" + bean.getName() + "'. Ensure that @ConstructorBinding has not been applied to regular bean");
        }
        try {
            this.binder.bind(bean);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindException(bean, ex);
        }
    }

    public static void register(BeanDefinitionRegistry registry) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(ConfigurationPropertiesBindingPostProcessor.class);
            definition.setRole(2);
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
        }
        ConfigurationPropertiesBinder.register(registry);
    }
}

