/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.PropertyEditorRegistry;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.properties.BoundConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationPropertiesBean;
import cn.taketoday.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import cn.taketoday.context.properties.ConfigurationPropertiesJsr303Validator;
import cn.taketoday.context.properties.ConversionServiceDeducer;
import cn.taketoday.context.properties.PropertySourcesDeducer;
import cn.taketoday.context.properties.bind.AbstractBindHandler;
import cn.taketoday.context.properties.bind.BindContext;
import cn.taketoday.context.properties.bind.BindHandler;
import cn.taketoday.context.properties.bind.BindResult;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.Binder;
import cn.taketoday.context.properties.bind.BoundPropertiesTrackingBindHandler;
import cn.taketoday.context.properties.bind.PlaceholdersResolver;
import cn.taketoday.context.properties.bind.PropertySourcesPlaceholdersResolver;
import cn.taketoday.context.properties.bind.handler.IgnoreErrorsBindHandler;
import cn.taketoday.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import cn.taketoday.context.properties.bind.handler.NoUnboundElementsBindHandler;
import cn.taketoday.context.properties.bind.validation.ValidationBindHandler;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.context.properties.source.ConfigurationPropertySource;
import cn.taketoday.context.properties.source.ConfigurationPropertySources;
import cn.taketoday.context.properties.source.UnboundElementsSourceFilter;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.validation.Validator;
import cn.taketoday.validation.annotation.Validated;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class ConfigurationPropertiesBinder {
    private static final String BEAN_NAME = "cn.taketoday.context.internalConfigurationPropertiesBinder";
    private static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    private final ApplicationContext applicationContext;
    private final PropertySources propertySources;
    @Nullable
    private final Validator configurationPropertiesValidator;
    private final boolean jsr303Present;
    @Nullable
    private volatile Validator jsr303Validator;
    @Nullable
    private volatile Binder binder;

    ConfigurationPropertiesBinder(ApplicationContext context) {
        this.applicationContext = context;
        this.propertySources = new PropertySourcesDeducer(context).getPropertySources();
        this.configurationPropertiesValidator = this.getConfigurationPropertiesValidator(context);
        this.jsr303Present = ConfigurationPropertiesJsr303Validator.isJsr303Present(context);
    }

    BindResult<?> bind(ConfigurationPropertiesBean propertiesBean) {
        Bindable<?> target = propertiesBean.asBindTarget();
        ConfigurationProperties annotation = propertiesBean.getAnnotation();
        BindHandler bindHandler = this.getBindHandler(target, annotation);
        return this.getBinder().bind(annotation.prefix(), target, bindHandler);
    }

    Object bindOrCreate(ConfigurationPropertiesBean propertiesBean) {
        Bindable<?> target = propertiesBean.asBindTarget();
        ConfigurationProperties annotation = propertiesBean.getAnnotation();
        BindHandler bindHandler = this.getBindHandler(target, annotation);
        return this.getBinder().bindOrCreate(annotation.prefix(), target, bindHandler);
    }

    @Nullable
    private Validator getConfigurationPropertiesValidator(ApplicationContext applicationContext) {
        if (applicationContext.containsBean(VALIDATOR_BEAN_NAME)) {
            return (Validator)applicationContext.getBean(VALIDATOR_BEAN_NAME, Validator.class);
        }
        return null;
    }

    private <T> BindHandler getBindHandler(Bindable<T> target, ConfigurationProperties annotation) {
        ArrayList<Validator> validators = this.getValidators(target);
        BindHandler handler = this.getHandler();
        handler = new ConfigurationPropertiesBindHandler(handler);
        if (annotation.ignoreInvalidFields()) {
            handler = new IgnoreErrorsBindHandler(handler);
        }
        if (!annotation.ignoreUnknownFields()) {
            UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
            handler = new NoUnboundElementsBindHandler(handler, filter);
        }
        if (!validators.isEmpty()) {
            handler = new ValidationBindHandler(handler, validators.toArray(new Validator[0]));
        }
        for (ConfigurationPropertiesBindHandlerAdvisor advisor : this.getBindHandlerAdvisors()) {
            handler = advisor.apply(handler);
        }
        return handler;
    }

    private IgnoreTopLevelConverterNotFoundBindHandler getHandler() {
        BoundConfigurationProperties bound = BoundConfigurationProperties.get(this.applicationContext);
        return bound != null ? new IgnoreTopLevelConverterNotFoundBindHandler(new BoundPropertiesTrackingBindHandler(bound::add)) : new IgnoreTopLevelConverterNotFoundBindHandler();
    }

    private ArrayList<Validator> getValidators(Bindable<?> target) {
        Object obj;
        ArrayList<Validator> validators = new ArrayList<Validator>(3);
        if (this.configurationPropertiesValidator != null) {
            validators.add(this.configurationPropertiesValidator);
        }
        if (this.jsr303Present && target.getAnnotation(Validated.class) != null) {
            validators.add(this.getJsr303Validator());
        }
        if (target.getValue() != null && (obj = target.getValue().get()) instanceof Validator) {
            Validator validator = (Validator)obj;
            validators.add(validator);
        }
        return validators;
    }

    private Validator getJsr303Validator() {
        Validator jsr303Validator = this.jsr303Validator;
        if (jsr303Validator == null) {
            this.jsr303Validator = jsr303Validator = new ConfigurationPropertiesJsr303Validator(this.applicationContext);
        }
        return jsr303Validator;
    }

    private List<ConfigurationPropertiesBindHandlerAdvisor> getBindHandlerAdvisors() {
        return this.applicationContext.getBeanProvider(ConfigurationPropertiesBindHandlerAdvisor.class).orderedStream().collect(Collectors.toList());
    }

    private Binder getBinder() {
        Binder binder = this.binder;
        if (binder == null) {
            this.binder = binder = new Binder(this.getConfigurationPropertySources(), (PlaceholdersResolver)this.getPropertySourcesPlaceholdersResolver(), this.getConversionServices(), this.getPropertyEditorInitializer(), null, null);
        }
        return binder;
    }

    private Iterable<ConfigurationPropertySource> getConfigurationPropertySources() {
        return ConfigurationPropertySources.from(this.propertySources);
    }

    private PropertySourcesPlaceholdersResolver getPropertySourcesPlaceholdersResolver() {
        return new PropertySourcesPlaceholdersResolver((Iterable<PropertySource<?>>)this.propertySources);
    }

    @Nullable
    private List<ConversionService> getConversionServices() {
        return new ConversionServiceDeducer(this.applicationContext).getConversionServices();
    }

    @Nullable
    private Consumer<PropertyEditorRegistry> getPropertyEditorInitializer() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return arg_0 -> ((ConfigurableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory()).copyRegisteredEditorsTo(arg_0);
        }
        return null;
    }

    static void register(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition(ConfigurationPropertiesBinderFactory.class).getBeanDefinition();
            definition.setRole(2);
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
        }
    }

    static ConfigurationPropertiesBinder get(BeanFactory beanFactory) {
        return (ConfigurationPropertiesBinder)beanFactory.getBean(BEAN_NAME, ConfigurationPropertiesBinder.class);
    }

    private static class ConfigurationPropertiesBindHandler
    extends AbstractBindHandler {
        ConfigurationPropertiesBindHandler(BindHandler handler) {
            super(handler);
        }

        @Override
        public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
            return this.isConfigurationProperties(target.getType().resolve()) ? target.withBindRestrictions(Bindable.BindRestriction.NO_DIRECT_PROPERTY) : target;
        }

        private boolean isConfigurationProperties(@Nullable Class<?> target) {
            return target != null && MergedAnnotations.from(target).isPresent(ConfigurationProperties.class);
        }
    }

    static class ConfigurationPropertiesBinderFactory
    implements FactoryBean<ConfigurationPropertiesBinder>,
    ApplicationContextAware {
        @Nullable
        private ConfigurationPropertiesBinder binder;

        ConfigurationPropertiesBinderFactory() {
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            if (this.binder == null) {
                this.binder = new ConfigurationPropertiesBinder(applicationContext);
            }
        }

        public Class<?> getObjectType() {
            return ConfigurationPropertiesBinder.class;
        }

        public ConfigurationPropertiesBinder getObject() throws Exception {
            Assert.state((this.binder != null ? 1 : 0) != 0, (String)"Binder was not created due to missing setApplicationContext call");
            return this.binder;
        }
    }
}

