/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.factory.annotation.Autowired;
import cn.taketoday.context.properties.bind.BindConstructorProvider;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.ConstructorBinding;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class ConfigurationPropertiesBindConstructorProvider
implements BindConstructorProvider {
    public static final ConfigurationPropertiesBindConstructorProvider INSTANCE = new ConfigurationPropertiesBindConstructorProvider();

    @Override
    public Constructor<?> getBindConstructor(Bindable<?> bindable, boolean isNestedConstructorBinding) {
        return this.getBindConstructor(bindable.getType().resolve(), isNestedConstructorBinding);
    }

    @Override
    @Nullable
    public Constructor<?> getBindConstructor(@Nullable Class<?> type, boolean isNestedConstructorBinding) {
        if (type == null) {
            return null;
        }
        Constructors constructors = Constructors.getConstructors(type);
        if ((constructors.getBind() != null || isNestedConstructorBinding) && constructors.hasAutowired()) {
            throw new IllegalStateException(type.getName() + " declares @ConstructorBinding and @Autowired constructor");
        }
        return constructors.getBind();
    }

    private record Constructors(boolean hasAutowired, @Nullable Constructor<?> bind) {
        @Nullable
        Constructor<?> getBind() {
            return this.bind;
        }

        static Constructors getConstructors(Class<?> type) {
            Constructor<?>[] candidates = Constructors.getCandidateConstructors(type);
            Constructor<?> deducedBind = Constructors.deduceBindConstructor(candidates);
            if (deducedBind != null) {
                return new Constructors(false, deducedBind);
            }
            boolean hasAutowiredConstructor = false;
            Constructor<?> bind = null;
            for (Constructor<?> candidate : candidates) {
                if (Constructors.isAutowired(candidate)) {
                    hasAutowiredConstructor = true;
                    continue;
                }
                bind = Constructors.findAnnotatedConstructor(type, bind, candidate);
            }
            return new Constructors(hasAutowiredConstructor, bind);
        }

        private static Constructor<?>[] getCandidateConstructors(Class<?> type) {
            if (Constructors.isInnerClass(type)) {
                return new Constructor[0];
            }
            return (Constructor[])Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> Constructors.isNonSynthetic(constructor, type)).toArray(Constructor[]::new);
        }

        private static boolean isInnerClass(Class<?> type) {
            try {
                return type.getDeclaredField("this$0").isSynthetic();
            }
            catch (NoSuchFieldException ex) {
                return false;
            }
        }

        private static boolean isNonSynthetic(Constructor<?> constructor, Class<?> type) {
            return !constructor.isSynthetic();
        }

        @Nullable
        private static Constructor<?> deduceBindConstructor(Constructor<?>[] constructors) {
            if (constructors.length == 1 && constructors[0].getParameterCount() > 0 && !Constructors.isAutowired(constructors[0])) {
                return constructors[0];
            }
            return null;
        }

        private static boolean isAutowired(Constructor<?> candidate) {
            return MergedAnnotations.from(candidate).isPresent(Autowired.class);
        }

        @Nullable
        private static Constructor<?> findAnnotatedConstructor(Class<?> type, @Nullable Constructor<?> constructor, Constructor<?> candidate) {
            if (MergedAnnotations.from(candidate).isPresent(ConstructorBinding.class)) {
                if (candidate.getParameterCount() <= 0) {
                    throw new IllegalStateException(type.getName() + " declares @ConstructorBinding on a no-args constructor");
                }
                if (constructor != null) {
                    throw new IllegalStateException(type.getName() + " has more than one @ConstructorBinding constructor");
                }
                constructor = candidate;
            }
            return constructor;
        }
    }
}

