/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.HierarchicalBeanFactory;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.properties.ConfigurationProperties;
import cn.taketoday.context.properties.ConfigurationPropertiesBean;
import cn.taketoday.context.properties.ConfigurationPropertiesBindException;
import cn.taketoday.context.properties.ConfigurationPropertiesBinder;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;

final class ConfigurationPropertiesBeanRegistrar {
    private final BeanDefinitionRegistry registry;
    private final BeanFactory beanFactory;

    ConfigurationPropertiesBeanRegistrar(BootstrapContext context) {
        this.registry = context.getRegistry();
        this.beanFactory = context.getBeanFactory();
    }

    void register(Class<?> type) {
        MergedAnnotation annotation = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ConfigurationProperties.class);
        this.register(type, (MergedAnnotation<ConfigurationProperties>)annotation);
    }

    void register(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        String name = this.getName(type, annotation);
        if (!this.containsBeanDefinition(name)) {
            this.registerBeanDefinition(name, type, annotation);
        }
    }

    private String getName(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        String prefix = annotation.isPresent() ? annotation.getString("prefix") : "";
        return StringUtils.hasText((String)prefix) ? prefix + "-" + type.getName() : type.getName();
    }

    private boolean containsBeanDefinition(String name) {
        return this.containsBeanDefinition(this.beanFactory, name);
    }

    private boolean containsBeanDefinition(@Nullable BeanFactory beanFactory, String name) {
        if (beanFactory != null && beanFactory.containsBeanDefinition(name)) {
            return true;
        }
        if (beanFactory instanceof HierarchicalBeanFactory) {
            HierarchicalBeanFactory hbf = (HierarchicalBeanFactory)beanFactory;
            return this.containsBeanDefinition(hbf.getParentBeanFactory(), name);
        }
        return false;
    }

    private void registerBeanDefinition(String beanName, Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        if (!annotation.isPresent()) {
            throw new IllegalStateException("No ConfigurationProperties annotation found on  '" + type.getName() + "'.");
        }
        this.registry.registerBeanDefinition(beanName, this.createBeanDefinition(beanName, type));
    }

    private BeanDefinition createBeanDefinition(String beanName, Class<?> type) {
        ConfigurationPropertiesBean.BindMethod bindMethod = ConfigurationPropertiesBean.BindMethod.forType(type);
        RootBeanDefinition definition = new RootBeanDefinition(type);
        definition.setAttribute(ConfigurationPropertiesBean.BindMethod.class.getName(), (Object)bindMethod);
        if (bindMethod == ConfigurationPropertiesBean.BindMethod.VALUE_OBJECT) {
            definition.setInstanceSupplier(() -> this.createValueObject(beanName, type));
        }
        return definition;
    }

    private Object createValueObject(String beanName, Class<?> beanType) {
        ConfigurationPropertiesBean bean = ConfigurationPropertiesBean.forValueObject(beanType, beanName);
        ConfigurationPropertiesBinder binder = ConfigurationPropertiesBinder.get(this.beanFactory);
        try {
            return binder.bindOrCreate(bean);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindException(bean, ex);
        }
    }
}

