/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.properties.ConfigurationProperties;
import cn.taketoday.context.properties.bind.BindConstructorProvider;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.validation.annotation.Validated;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class ConfigurationPropertiesBean {
    private final String name;
    @Nullable
    private final Object instance;
    private final ConfigurationProperties annotation;
    private final Bindable<?> bindTarget;
    private final BindMethod bindMethod;

    private ConfigurationPropertiesBean(String name, @Nullable Object instance, ConfigurationProperties annotation, Bindable<?> bindTarget, @Nullable BindMethod bindMethod) {
        this.name = name;
        this.instance = instance;
        this.annotation = annotation;
        this.bindTarget = bindTarget;
        this.bindMethod = bindMethod != null ? bindMethod : BindMethod.get(bindTarget);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Object getInstance() {
        return this.instance;
    }

    @Nullable
    Class<?> getType() {
        return this.bindTarget.getType().resolve();
    }

    public BindMethod getBindMethod() {
        return this.bindMethod;
    }

    public ConfigurationProperties getAnnotation() {
        return this.annotation;
    }

    public Bindable<?> asBindTarget() {
        return this.bindTarget;
    }

    public static Map<String, ConfigurationPropertiesBean> getAll(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return ConfigurationPropertiesBean.getAll((ConfigurableApplicationContext)applicationContext);
        }
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        Map beansWithAnnotation = applicationContext.getBeansWithAnnotation(ConfigurationProperties.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            String beanName;
            Object bean = entry.getValue();
            ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get(applicationContext, bean, beanName = (String)entry.getKey());
            if (propertiesBean == null) continue;
            propertiesBeans.put(beanName, propertiesBean);
        }
        return propertiesBeans;
    }

    private static Map<String, ConfigurationPropertiesBean> getAll(ConfigurableApplicationContext applicationContext) {
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        ConfigurableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Iterator beanNames = beanFactory.getBeanNamesIterator();
        while (beanNames.hasNext()) {
            String beanName = (String)beanNames.next();
            if (!ConfigurationPropertiesBean.isConfigurationPropertiesBean(beanFactory, beanName)) continue;
            try {
                BindMethod bindMethod;
                Object bean = beanFactory.getBean(beanName);
                ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get(applicationContext, bean, beanName, bindMethod = ConfigurationPropertiesBean.getBindMethod(beanFactory, beanName));
                if (propertiesBean == null) continue;
                propertiesBeans.put(beanName, propertiesBean);
            }
            catch (Exception exception) {}
        }
        return propertiesBeans;
    }

    @Nullable
    private static BindMethod getBindMethod(ConfigurableBeanFactory beanFactory, String beanName) {
        try {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            return (BindMethod)((Object)beanDefinition.getAttribute(BindMethod.class.getName()));
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private static boolean isConfigurationPropertiesBean(ConfigurableBeanFactory beanFactory, String beanName) {
        try {
            if (beanFactory.getBeanDefinition(beanName).isAbstract()) {
                return false;
            }
            if (beanFactory.findAnnotationOnBean(beanName, ConfigurationProperties.class).isPresent()) {
                return true;
            }
            Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(beanFactory, beanName);
            return ConfigurationPropertiesBean.findMergedAnnotation(factoryMethod, ConfigurationProperties.class).isPresent();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    @Nullable
    public static ConfigurationPropertiesBean get(ApplicationContext applicationContext, Object bean, String beanName) {
        return ConfigurationPropertiesBean.get(applicationContext, bean, beanName, null);
    }

    @Nullable
    private static ConfigurationPropertiesBean get(ApplicationContext applicationContext, Object bean, String beanName, @Nullable BindMethod bindMethod) {
        Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(applicationContext, beanName);
        return ConfigurationPropertiesBean.create(beanName, bean, bean.getClass(), factoryMethod, bindMethod);
    }

    @Nullable
    private static Method findFactoryMethod(ApplicationContext applicationContext, String beanName) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return ConfigurationPropertiesBean.findFactoryMethod((ConfigurableApplicationContext)applicationContext, beanName);
        }
        return null;
    }

    @Nullable
    private static Method findFactoryMethod(ConfigurableApplicationContext applicationContext, String beanName) {
        return ConfigurationPropertiesBean.findFactoryMethod(applicationContext.getBeanFactory(), beanName);
    }

    @Nullable
    private static Method findFactoryMethod(ConfigurableBeanFactory beanFactory, String beanName) {
        BeanDefinition beanDefinition;
        if (beanFactory.containsBeanDefinition(beanName) && (beanDefinition = beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            RootBeanDefinition merged = (RootBeanDefinition)beanDefinition;
            Method resolvedFactoryMethod = merged.getResolvedFactoryMethod();
            if (resolvedFactoryMethod != null) {
                return resolvedFactoryMethod;
            }
            return ConfigurationPropertiesBean.findFactoryMethodUsingReflection(beanFactory, beanDefinition);
        }
        return null;
    }

    @Nullable
    private static Method findFactoryMethodUsingReflection(ConfigurableBeanFactory beanFactory, BeanDefinition beanDefinition) {
        String factoryMethodName = beanDefinition.getFactoryMethodName();
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        if (factoryMethodName == null || factoryBeanName == null) {
            return null;
        }
        Class factoryType = beanFactory.getType(factoryBeanName);
        if (factoryType != null && factoryType.getName().contains("$$")) {
            factoryType = factoryType.getSuperclass();
        }
        AtomicReference factoryMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(factoryType, method -> {
            if (method.getName().equals(factoryMethodName)) {
                factoryMethod.set(method);
            }
        });
        return (Method)factoryMethod.get();
    }

    static ConfigurationPropertiesBean forValueObject(Class<?> beanClass, String beanName) {
        ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.create(beanName, null, beanClass, null, null);
        if (propertiesBean == null || propertiesBean.getBindMethod() != BindMethod.VALUE_OBJECT) {
            throw new IllegalStateException("Bean '" + beanName + "' is not a @ConfigurationProperties value object");
        }
        return propertiesBean;
    }

    @Nullable
    private static ConfigurationPropertiesBean create(String name, @Nullable Object instance, Class<?> type, @Nullable Method factory, @Nullable BindMethod bindMethod) {
        Annotation[] annotationArray;
        ConfigurationProperties annotation = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, ConfigurationProperties.class);
        if (annotation == null) {
            return null;
        }
        Validated validated = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, Validated.class);
        if (validated != null) {
            Annotation[] annotationArray2 = new Annotation[2];
            annotationArray2[0] = annotation;
            annotationArray = annotationArray2;
            annotationArray2[1] = validated;
        } else {
            Annotation[] annotationArray3 = new Annotation[1];
            annotationArray = annotationArray3;
            annotationArray3[0] = annotation;
        }
        Annotation[] annotations = annotationArray;
        ResolvableType bindType = factory != null ? ResolvableType.forReturnType((Method)factory) : ResolvableType.fromClass(type);
        Bindable<Object> bindable = Bindable.of(bindType).withAnnotations(annotations);
        BindMethod bindMethod2 = bindMethod = factory != null ? BindMethod.JAVA_BEAN : bindMethod;
        if (instance != null && bindMethod != BindMethod.VALUE_OBJECT) {
            bindable = bindable.withExistingValue(instance);
        }
        return new ConfigurationPropertiesBean(name, instance, annotation, bindable, bindMethod);
    }

    @Nullable
    private static <A extends Annotation> A findAnnotation(@Nullable Object instance, Class<?> type, @Nullable Method factory, Class<A> annotationType) {
        MergedAnnotation annotation = MergedAnnotation.missing();
        if (factory != null) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(factory, annotationType);
        }
        if (!annotation.isPresent()) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(type, annotationType);
        }
        if (!annotation.isPresent() && AopUtils.isAopProxy((Object)instance)) {
            annotation = MergedAnnotations.from((AnnotatedElement)AopUtils.getTargetClass((Object)instance), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        return (A)(annotation.isPresent() ? annotation.synthesize() : null);
    }

    private static <A extends Annotation> MergedAnnotation<A> findMergedAnnotation(@Nullable AnnotatedElement element, Class<A> annotationType) {
        return element != null ? MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType) : MergedAnnotation.missing();
    }

    public static enum BindMethod {
        JAVA_BEAN,
        VALUE_OBJECT;


        static BindMethod get(Bindable<?> bindable) {
            return BindMethod.get(BindConstructorProvider.DEFAULT.getBindConstructor(bindable, false));
        }

        private static BindMethod get(@Nullable Constructor<?> bindConstructor) {
            return bindConstructor != null ? VALUE_OBJECT : JAVA_BEAN;
        }

        public static BindMethod forType(Class<?> type) {
            return BindMethod.get(BindConstructorProvider.DEFAULT.getBindConstructor(type, false));
        }
    }
}

