/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.properties.source.ConfigurationProperty;
import cn.taketoday.context.properties.source.ConfigurationPropertyName;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class BoundConfigurationProperties {
    private final LinkedHashMap<ConfigurationPropertyName, ConfigurationProperty> properties = new LinkedHashMap();
    private static final String BEAN_NAME = BoundConfigurationProperties.class.getName();

    void add(ConfigurationProperty configurationProperty) {
        this.properties.put(configurationProperty.getName(), configurationProperty);
    }

    @Nullable
    public ConfigurationProperty get(ConfigurationPropertyName name) {
        return this.properties.get(name);
    }

    public Map<ConfigurationPropertyName, ConfigurationProperty> getAll() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Nullable
    public static BoundConfigurationProperties get(ApplicationContext context) {
        if (!context.containsBeanDefinition(BEAN_NAME)) {
            return null;
        }
        return (BoundConfigurationProperties)context.getBean(BEAN_NAME, BoundConfigurationProperties.class);
    }

    static void register(BeanDefinitionRegistry registry) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(BoundConfigurationProperties.class, BoundConfigurationProperties::new).getBeanDefinition();
            definition.setRole(2);
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
        }
    }
}

