/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.index;

import cn.taketoday.context.index.CandidateComponentsIndex;
import cn.taketoday.core.io.PropertiesUtils;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.UrlResource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;

public final class CandidateComponentsIndexLoader {
    public static final String COMPONENTS_RESOURCE_LOCATION = "META-INF/today.components";
    public static final String IGNORE_INDEX = "today.index.ignore";
    private static final boolean shouldIgnoreIndex = TodayStrategies.getFlag((String)"today.index.ignore");
    private static final Logger log = LoggerFactory.getLogger(CandidateComponentsIndexLoader.class);
    private static final ConcurrentMap<ClassLoader, CandidateComponentsIndex> cache = new ConcurrentReferenceHashMap();

    private CandidateComponentsIndexLoader() {
    }

    @Nullable
    public static CandidateComponentsIndex loadIndex(@Nullable ClassLoader classLoader) {
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = CandidateComponentsIndexLoader.class.getClassLoader();
        }
        return cache.computeIfAbsent(classLoaderToUse, CandidateComponentsIndexLoader::doLoadIndex);
    }

    @Nullable
    private static CandidateComponentsIndex doLoadIndex(ClassLoader classLoader) {
        if (shouldIgnoreIndex) {
            return null;
        }
        try {
            int totalCount;
            Enumeration<URL> urls = classLoader.getResources(COMPONENTS_RESOURCE_LOCATION);
            if (!urls.hasMoreElements()) {
                return null;
            }
            ArrayList<Properties> result = new ArrayList<Properties>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Properties properties = PropertiesUtils.loadProperties((Resource)new UrlResource(url));
                result.add(properties);
            }
            if (log.isDebugEnabled()) {
                log.debug("Loaded {} index(es)", (Object)result.size());
            }
            return (totalCount = result.stream().mapToInt(Properties::size).sum()) > 0 ? new CandidateComponentsIndex(result) : null;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load indexes from location [META-INF/today.components]", ex);
        }
    }
}

