/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.expression;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanExpressionException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.config.BeanExpressionContext;
import cn.taketoday.beans.factory.config.BeanExpressionResolver;
import cn.taketoday.context.expression.BeanExpressionContextAccessor;
import cn.taketoday.context.expression.BeanFactoryAccessor;
import cn.taketoday.context.expression.BeanFactoryResolver;
import cn.taketoday.context.expression.EnvironmentAccessor;
import cn.taketoday.context.expression.MapAccessor;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.expression.BeanResolver;
import cn.taketoday.expression.EvaluationContext;
import cn.taketoday.expression.Expression;
import cn.taketoday.expression.ExpressionParser;
import cn.taketoday.expression.ParserContext;
import cn.taketoday.expression.PropertyAccessor;
import cn.taketoday.expression.TypeConverter;
import cn.taketoday.expression.TypeLocator;
import cn.taketoday.expression.spel.SpelParserConfiguration;
import cn.taketoday.expression.spel.standard.SpelExpressionParser;
import cn.taketoday.expression.spel.support.StandardEvaluationContext;
import cn.taketoday.expression.spel.support.StandardTypeConverter;
import cn.taketoday.expression.spel.support.StandardTypeLocator;
import cn.taketoday.format.support.ApplicationConversionService;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.concurrent.ConcurrentHashMap;

public class StandardBeanExpressionResolver
implements BeanExpressionResolver {
    public static final String DEFAULT_EXPRESSION_PREFIX = "#{";
    public static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "#{";
    private String expressionSuffix = "}";
    private ExpressionParser expressionParser;
    private final ConcurrentHashMap<String, Expression> expressionCache = new ConcurrentHashMap(256);
    private final ConcurrentHashMap<BeanExpressionContext, StandardEvaluationContext> evaluationCache = new ConcurrentHashMap(8);
    private final ParserContext beanExpressionParserContext = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return StandardBeanExpressionResolver.this.expressionPrefix;
        }

        public String getExpressionSuffix() {
            return StandardBeanExpressionResolver.this.expressionSuffix;
        }
    };

    public StandardBeanExpressionResolver() {
        this.expressionParser = new SpelExpressionParser();
    }

    public StandardBeanExpressionResolver(@Nullable ClassLoader beanClassLoader) {
        this.expressionParser = new SpelExpressionParser(new SpelParserConfiguration(null, beanClassLoader));
    }

    public void setExpressionPrefix(String expressionPrefix) {
        Assert.hasText((String)expressionPrefix, (String)"Expression prefix must not be empty");
        this.expressionPrefix = expressionPrefix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        Assert.hasText((String)expressionSuffix, (String)"Expression suffix must not be empty");
        this.expressionSuffix = expressionSuffix;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        this.expressionParser = expressionParser;
    }

    @Nullable
    public Object evaluate(@Nullable String value, BeanExpressionContext evalContext) throws BeansException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        try {
            StandardEvaluationContext sec;
            Expression expr = this.expressionCache.get(value);
            if (expr == null) {
                expr = this.expressionParser.parseExpression(value, this.beanExpressionParserContext);
                this.expressionCache.put(value, expr);
            }
            if ((sec = this.evaluationCache.get(evalContext)) == null) {
                sec = new StandardEvaluationContext((Object)evalContext);
                sec.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
                sec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)evalContext.getBeanFactory()));
                sec.setTypeLocator((TypeLocator)new StandardTypeLocator(evalContext.getBeanFactory().getBeanClassLoader()));
                sec.setTypeConverter((TypeConverter)new StandardTypeConverter(() -> {
                    ConversionService cs = evalContext.getBeanFactory().getConversionService();
                    return cs != null ? cs : ApplicationConversionService.getSharedInstance();
                }));
                this.customizeEvaluationContext(sec);
                this.evaluationCache.put(evalContext, sec);
            }
            return expr.getValue((EvaluationContext)sec);
        }
        catch (Throwable ex) {
            throw new BeanExpressionException("Expression parsing failed", ex);
        }
    }

    protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
    }
}

