/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.expression;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.core.CodeFlow;
import cn.taketoday.expression.AccessException;
import cn.taketoday.expression.EvaluationContext;
import cn.taketoday.expression.TypedValue;
import cn.taketoday.expression.spel.CompilablePropertyAccessor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.Map;

public class MapAccessor
implements CompilablePropertyAccessor {
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
        Map map;
        return target instanceof Map && (map = (Map)target).containsKey(name);
    }

    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
        Assert.state((boolean)(target instanceof Map), (String)"Target must be of type Map");
        Map map = (Map)target;
        Object value = map.get(name);
        if (value == null && !map.containsKey(name)) {
            throw new MapAccessException(name);
        }
        return new TypedValue(value);
    }

    public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
        return true;
    }

    public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) throws AccessException {
        Assert.state((boolean)(target instanceof Map), (String)"Target must be a Map");
        Map map = (Map)target;
        map.put(name, newValue);
    }

    public boolean isCompilable() {
        return true;
    }

    public Class<?> getPropertyType() {
        return Object.class;
    }

    public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
        String descriptor = cf.lastDescriptor();
        if (descriptor == null || !descriptor.equals("Ljava/util/Map")) {
            if (descriptor == null) {
                cf.loadTarget(mv);
            }
            CodeFlow.insertCheckCast((MethodVisitor)mv, (String)"Ljava/util/Map");
        }
        mv.visitLdcInsn((Object)propertyName);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
    }

    private static class MapAccessException
    extends AccessException {
        private final String key;

        public MapAccessException(String key) {
            super("");
            this.key = key;
        }

        public String getMessage() {
            return "Map does not contain a value for key '" + this.key + "'";
        }
    }
}

