/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.expression;

import cn.taketoday.context.expression.AnnotatedElementKey;
import cn.taketoday.core.DefaultParameterNameDiscoverer;
import cn.taketoday.core.ParameterNameDiscoverer;
import cn.taketoday.expression.Expression;
import cn.taketoday.expression.spel.standard.SpelExpressionParser;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.Map;

public abstract class CachedExpressionEvaluator {
    protected final SpelExpressionParser parser;
    protected final ParameterNameDiscoverer parameterNameDiscoverer;

    protected CachedExpressionEvaluator() {
        this(new SpelExpressionParser());
    }

    protected CachedExpressionEvaluator(SpelExpressionParser parser) {
        this(parser, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
    }

    protected CachedExpressionEvaluator(SpelExpressionParser parser, ParameterNameDiscoverer parameterNameDiscoverer) {
        Assert.notNull((Object)parser, (String)"SpelExpressionParser is required");
        Assert.notNull((Object)parameterNameDiscoverer, (String)"ParameterNameDiscoverer is required");
        this.parser = parser;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    protected Expression getExpression(Map<ExpressionKey, Expression> cache, AnnotatedElementKey elementKey, String expression) {
        ExpressionKey expressionKey = this.createKey(elementKey, expression);
        Expression expr = cache.get(expressionKey);
        if (expr == null) {
            expr = this.parseExpression(expression);
            cache.put(expressionKey, expr);
        }
        return expr;
    }

    protected Expression parseExpression(String expression) {
        return this.parser.parseExpression(expression);
    }

    private ExpressionKey createKey(AnnotatedElementKey elementKey, String expression) {
        return new ExpressionKey(elementKey, expression);
    }

    protected static class ExpressionKey
    implements Comparable<ExpressionKey> {
        private final String expression;
        private final AnnotatedElementKey element;

        protected ExpressionKey(AnnotatedElementKey element, String expression) {
            Assert.notNull((Object)element, (String)"AnnotatedElementKey is required");
            Assert.notNull((Object)expression, (String)"Expression is required");
            this.element = element;
            this.expression = expression;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpressionKey)) {
                return false;
            }
            ExpressionKey otherKey = (ExpressionKey)other;
            return this.element.equals(otherKey.element) && this.expression.equals(otherKey.expression);
        }

        public int hashCode() {
            return this.element.hashCode() * 29 + this.expression.hashCode();
        }

        public String toString() {
            return this.element + " with expression \"" + this.expression + "\"";
        }

        @Override
        public int compareTo(ExpressionKey other) {
            int result = this.element.toString().compareTo(other.element.toString());
            if (result == 0) {
                result = this.expression.compareTo(other.expression);
            }
            return result;
        }
    }
}

