/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.event.GenericApplicationListener;
import cn.taketoday.context.event.SmartApplicationListener;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.util.Map;

public class GenericApplicationListenerAdapter
implements GenericApplicationListener {
    private static final Map<Class<?>, ResolvableType> eventTypeCache = new ConcurrentReferenceHashMap();
    private final ApplicationListener delegate;
    @Nullable
    private final ResolvableType declaredEventType;

    public GenericApplicationListenerAdapter(ApplicationListener delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate listener must not be null");
        this.delegate = delegate;
        this.declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        if (this.delegate instanceof GenericApplicationListener) {
            return ((GenericApplicationListener)this.delegate).supportsEventType(eventType);
        }
        if (this.delegate instanceof SmartApplicationListener) {
            Class eventClass = eventType.resolve();
            return eventClass != null && ((SmartApplicationListener)this.delegate).supportsEventType(eventClass);
        }
        return this.declaredEventType == null || this.declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return !(this.delegate instanceof SmartApplicationListener) || ((SmartApplicationListener)this.delegate).supportsSourceType(sourceType);
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)this.delegate).getOrder() : Integer.MAX_VALUE;
    }

    @Override
    public String getListenerId() {
        String string;
        ApplicationListener applicationListener = this.delegate;
        if (applicationListener instanceof SmartApplicationListener) {
            SmartApplicationListener smart = (SmartApplicationListener)applicationListener;
            string = smart.getListenerId();
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    private static ResolvableType resolveDeclaredEventType(ApplicationListener<?> listener) {
        Class targetClass;
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listener.getClass());
        if ((declaredEventType == null || declaredEventType.isAssignableFrom(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass(listener)) != listener.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType;
    }

    @Nullable
    static ResolvableType resolveDeclaredEventType(Class<?> listenerType) {
        ResolvableType eventType = eventTypeCache.get(listenerType);
        if (eventType == null) {
            eventType = ResolvableType.fromClass(listenerType).as(ApplicationListener.class).getGeneric(new int[0]);
            eventTypeCache.put(listenerType, eventType);
        }
        return eventType != ResolvableType.NONE ? eventType : null;
    }
}

