/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.context.ApplicationEventPublisher;
import cn.taketoday.context.ApplicationEventPublisherAware;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class EventPublicationInterceptor
implements MethodInterceptor,
ApplicationEventPublisherAware,
InitializingBean {
    @Nullable
    private Constructor<?> applicationEventConstructor;
    @Nullable
    private ApplicationEventPublisher applicationEventPublisher;
    @Nullable
    private Supplier<?> applicationEventSupplier;

    public void setApplicationEventClass(Class<?> applicationEventClass) {
        if (Modifier.isAbstract(applicationEventClass.getModifiers())) {
            throw new IllegalArgumentException("'applicationEventClass' cannot be abstract");
        }
        try {
            this.applicationEventConstructor = applicationEventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("ApplicationEvent class [" + applicationEventClass.getName() + "] does not have the required Object constructor: " + ex);
        }
    }

    public void setApplicationEventSupplier(@Nullable Supplier<?> applicationEventSupplier) {
        this.applicationEventSupplier = applicationEventSupplier;
    }

    @Override
    public void setApplicationEventPublisher(@NonNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationEventConstructor == null && this.applicationEventSupplier == null) {
            throw new IllegalArgumentException("applicationEventConstructor and applicationEventSupplier must not be null at same time");
        }
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        Assert.state((this.applicationEventPublisher != null ? 1 : 0) != 0, (String)"No ApplicationEventPublisher available");
        Object event = this.getEventObject(invocation);
        this.applicationEventPublisher.publishEvent(event);
        return retVal;
    }

    @NonNull
    private Object getEventObject(MethodInvocation invocation) throws Exception {
        if (this.applicationEventSupplier != null) {
            return this.applicationEventSupplier.get();
        }
        if (this.applicationEventConstructor != null) {
            return this.applicationEventConstructor.newInstance(invocation.getThis());
        }
        throw new IllegalStateException("Event object cannot be determined");
    }
}

