/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.aop.framework.autoproxy.AutoProxyUtils;
import cn.taketoday.aop.scope.ScopedObject;
import cn.taketoday.aop.scope.ScopedProxyUtils;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.BeanInitializationException;
import cn.taketoday.beans.factory.SmartInitializingSingleton;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.event.ApplicationListenerMethodAdapter;
import cn.taketoday.context.event.EventExpressionEvaluator;
import cn.taketoday.context.event.EventListener;
import cn.taketoday.context.event.EventListenerFactory;
import cn.taketoday.core.MethodIntrospector;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EventListenerMethodProcessor
implements BeanFactoryPostProcessor,
SmartInitializingSingleton,
ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private List<EventListenerFactory> eventListenerFactories;
    private final EventExpressionEvaluator evaluator = new EventExpressionEvaluator();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    @Nullable
    private ConfigurableApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
        Map beans = beanFactory.getBeansOfType(EventListenerFactory.class, false, false);
        ArrayList factories = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(factories);
        this.eventListenerFactories = factories;
    }

    public void afterSingletonsInstantiated(ConfigurableBeanFactory beanFactory) {
        Set beanNames = beanFactory.getBeanNamesForType(Object.class);
        for (String beanName : beanNames) {
            if (ScopedProxyUtils.isScopedTarget((String)beanName)) continue;
            Class type = null;
            try {
                type = AutoProxyUtils.determineTargetClass((ConfigurableBeanFactory)beanFactory, (String)beanName);
            }
            catch (Throwable ex) {
                this.logger.debug("Could not resolve target class for bean with name '{}'", (Object)beanName, (Object)ex);
            }
            if (type == null) continue;
            if (ScopedObject.class.isAssignableFrom(type)) {
                try {
                    Class targetClass = AutoProxyUtils.determineTargetClass((ConfigurableBeanFactory)beanFactory, (String)ScopedProxyUtils.getTargetBeanName((String)beanName));
                    if (targetClass != null) {
                        type = targetClass;
                    }
                }
                catch (Throwable ex) {
                    this.logger.debug("Could not resolve target bean for scoped proxy '{}'", (Object)beanName, (Object)ex);
                }
            }
            try {
                this.process(beanName, type);
            }
            catch (Throwable ex) {
                throw new BeanInitializationException("Failed to process @EventListener annotation on bean with name '" + beanName + "': " + ex.getMessage(), ex);
            }
        }
    }

    private void process(String beanName, Class<?> targetType) {
        if (!this.nonAnnotatedClasses.contains(targetType) && AnnotationUtils.isCandidateClass(targetType, EventListener.class)) {
            Set annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.filterMethods(targetType, method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, EventListener.class));
            }
            catch (Throwable ex) {
                this.logger.debug("Could not resolve methods for bean with name '{}'", (Object)beanName, (Object)ex);
            }
            if (CollectionUtils.isEmpty((Collection)annotatedMethods)) {
                this.nonAnnotatedClasses.add(targetType);
                this.logger.trace("No @EventListener annotations found on bean class: {}", (Object)targetType.getName());
            } else {
                ConfigurableApplicationContext context = this.applicationContext;
                Assert.state((context != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
                List<EventListenerFactory> factories = this.eventListenerFactories;
                Assert.state((factories != null ? 1 : 0) != 0, (String)"EventListenerFactory List not initialized");
                block2: for (Method method2 : annotatedMethods) {
                    for (EventListenerFactory factory : factories) {
                        if (!factory.supportsMethod(method2)) continue;
                        Method methodToUse = AopUtils.selectInvocableMethod((Method)method2, (Class)context.getType(beanName));
                        ApplicationListener<?> listener = factory.createApplicationListener(beanName, targetType, methodToUse);
                        if (listener instanceof ApplicationListenerMethodAdapter) {
                            ApplicationListenerMethodAdapter adapter = (ApplicationListenerMethodAdapter)listener;
                            adapter.init(context, this.evaluator);
                        }
                        context.addApplicationListener(listener);
                        continue block2;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @EventListener methods processed on bean '{}': {}", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
                }
            }
        }
    }
}

