/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.PayloadApplicationEvent;
import cn.taketoday.context.event.EventExpressionEvaluator;
import cn.taketoday.context.event.EventListener;
import cn.taketoday.context.event.GenericApplicationListener;
import cn.taketoday.context.expression.AnnotatedElementKey;
import cn.taketoday.core.BridgeMethodResolver;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.ReactiveAdapter;
import cn.taketoday.core.ReactiveAdapterRegistry;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.Order;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import cn.taketoday.util.concurrent.ListenableFuture;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ApplicationListenerMethodAdapter
implements GenericApplicationListener,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ApplicationListenerMethodAdapter.class);
    private static final boolean reactiveStreamsPresent = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)ApplicationListenerMethodAdapter.class.getClassLoader());
    private final Method method;
    private final Method targetMethod;
    private ApplicationContext context;
    @Nullable
    private EventExpressionEvaluator evaluator;
    @Nullable
    private final String condition;
    private final String beanName;
    private final int order;
    @Nullable
    private volatile String listenerId;
    private final List<ResolvableType> declaredEventTypes;
    private final AnnotatedElementKey methodKey;

    public ApplicationListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        this.beanName = beanName;
        this.method = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.targetMethod = Proxy.isProxyClass(targetClass) ? this.method : AopUtils.getMostSpecificMethod((Method)method, targetClass);
        this.methodKey = new AnnotatedElementKey(this.targetMethod, targetClass);
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)this.targetMethod, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation annotation = annotations.get(EventListener.class);
        this.declaredEventTypes = ApplicationListenerMethodAdapter.resolveDeclaredEventTypes(method, (MergedAnnotation<EventListener>)annotation);
        this.condition = annotation.getValue("condition", String.class).filter(StringUtils::hasText).orElse(null);
        if (annotation.isPresent()) {
            String id = annotation.getString("id");
            this.listenerId = !id.isEmpty() ? id : null;
        }
        MergedAnnotation order = annotations.get(Order.class);
        this.order = order.getValue(Integer.class).orElse(Integer.MAX_VALUE);
    }

    protected void init(ApplicationContext context, @Nullable EventExpressionEvaluator evaluator) {
        this.context = context;
        this.evaluator = evaluator;
    }

    private static List<ResolvableType> resolveDeclaredEventTypes(Method method, @Nullable MergedAnnotation<EventListener> ann) {
        Class[] classes;
        int count = method.getParameterCount();
        if (count > 1) {
            throw new IllegalStateException("Maximum one parameter is allowed for event listener method: " + method);
        }
        if (ann != null && (classes = ann.getClassArray("event")).length > 0) {
            ArrayList<ResolvableType> types = new ArrayList<ResolvableType>(classes.length);
            for (Class eventType : classes) {
                types.add(ResolvableType.fromClass((Class)eventType));
            }
            return types;
        }
        if (count == 0) {
            throw new IllegalStateException("Event parameter is mandatory for event listener method: " + method);
        }
        return Collections.singletonList(ResolvableType.forParameter((Executable)method, (int)0));
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    protected Object getTargetBean() {
        Assert.state((this.context != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
        return this.context.getBean(this.beanName);
    }

    protected Method getTargetMethod() {
        return this.targetMethod;
    }

    @Nullable
    protected String getCondition() {
        return this.condition;
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        for (ResolvableType declaredEventType : this.declaredEventTypes) {
            ResolvableType payloadType;
            if (declaredEventType.isAssignableFrom(eventType)) {
                return true;
            }
            if (!PayloadApplicationEvent.class.isAssignableFrom(eventType.toClass()) || !declaredEventType.isAssignableFrom(payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]))) continue;
            return true;
        }
        return eventType.hasUnresolvableGenerics();
    }

    @Override
    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return true;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        Object[] parameter = this.resolveArguments(event);
        if (this.shouldInvoke(event, parameter)) {
            Object result = this.doInvoke(parameter);
            if (result != null) {
                this.handleResult(result);
            } else {
                log.trace("No result object given - no result to handle");
            }
        }
    }

    private boolean shouldInvoke(Object event, @Nullable Object[] args) {
        if (args == null) {
            return false;
        }
        if (this.condition != null) {
            Assert.notNull((Object)this.evaluator, (String)"EventExpressionEvaluator is required");
            return this.evaluator.condition(this.condition, event, this.targetMethod, this.methodKey, args, (BeanFactory)this.context);
        }
        return true;
    }

    @Nullable
    protected Object[] resolveArguments(ApplicationEvent event) {
        Object payload;
        ResolvableType declaredEventType = this.getResolvableType(event);
        if (declaredEventType == null) {
            return null;
        }
        if (this.method.getParameterCount() == 0) {
            return Constant.EMPTY_OBJECTS;
        }
        Class declaredEventClass = declaredEventType.toClass();
        if (!ApplicationEvent.class.isAssignableFrom(declaredEventClass) && event instanceof PayloadApplicationEvent && declaredEventClass.isInstance(payload = ((PayloadApplicationEvent)event).getPayload())) {
            return new Object[]{payload};
        }
        return new Object[]{event};
    }

    @Nullable
    private ResolvableType getResolvableType(ApplicationEvent event) {
        PayloadApplicationEvent payloadEvent;
        ResolvableType eventType;
        ResolvableType payloadType = null;
        if (event instanceof PayloadApplicationEvent && (eventType = (payloadEvent = (PayloadApplicationEvent)event).getResolvableType()) != null) {
            payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]);
        }
        for (ResolvableType declaredEventType : this.declaredEventTypes) {
            Class eventClass = declaredEventType.toClass();
            if (!ApplicationEvent.class.isAssignableFrom(eventClass) && payloadType != null && declaredEventType.isAssignableFrom(payloadType)) {
                return declaredEventType;
            }
            if (!eventClass.isInstance(event)) continue;
            return declaredEventType;
        }
        return null;
    }

    @Nullable
    protected Object doInvoke(Object[] args) {
        Object bean = this.getTargetBean();
        if (bean == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Method)this.method);
        try {
            return this.method.invoke(bean, args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.method, bean, args);
            throw new IllegalStateException(this.getInvocationErrorMessage(bean, ex.getMessage(), args), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(this.getInvocationErrorMessage(bean, ex.getMessage(), args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            String msg = this.getInvocationErrorMessage(bean, "Failed to invoke event listener method", args);
            throw new UndeclaredThrowableException(targetException, msg);
        }
    }

    @Override
    @Nullable
    public String getListenerId() {
        String id = this.listenerId;
        if (id == null) {
            this.listenerId = id = this.getDefaultListenerId();
        }
        return id;
    }

    protected String getDefaultListenerId() {
        Method method = this.getTargetMethod();
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (Class<?> paramType : method.getParameterTypes()) {
            sj.add(paramType.getName());
        }
        return ClassUtils.getQualifiedMethodName((Method)method) + sj;
    }

    protected void handleResult(Object result) {
        if (reactiveStreamsPresent && ReactiveDelegate.subscribeToPublisher(this, result)) {
            if (log.isTraceEnabled()) {
                log.trace("Adapted to reactive result: {}", result);
            }
        } else if (result instanceof CompletionStage) {
            ((CompletionStage)result).whenComplete((event, ex) -> {
                if (ex != null) {
                    this.handleAsyncError((Throwable)ex);
                } else if (event != null) {
                    this.publishEvent(event);
                }
            });
        } else if (result instanceof ListenableFuture) {
            ((ListenableFuture)result).addCallback(this::publishEvents, this::handleAsyncError);
        } else {
            this.publishEvents(result);
        }
    }

    private void publishEvents(Object result) {
        if (result.getClass().isArray()) {
            Object[] events;
            for (Object event : events = ObjectUtils.toObjectArray((Object)result)) {
                this.publishEvent(event);
            }
        } else if (result instanceof Collection) {
            Collection events = (Collection)result;
            for (Object event : events) {
                this.publishEvent(event);
            }
        } else {
            this.publishEvent(result);
        }
    }

    private void publishEvent(@Nullable Object event) {
        if (event != null) {
            this.context.publishEvent(event);
        }
    }

    protected void handleAsyncError(Throwable t) {
        log.error("Unexpected error occurred in asynchronous listener", t);
    }

    protected String getDetailedErrorMessage(Object bean, String message) {
        StringBuilder sb = new StringBuilder(message).append('\n');
        sb.append("HandlerMethod details: \n");
        sb.append("Bean [").append(bean.getClass().getName()).append("]\n");
        sb.append("Method [").append(this.targetMethod.toGenericString()).append("]\n");
        return sb.toString();
    }

    private void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String msg = "The event listener method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual bean class '" + targetBeanClass.getName() + "'. If the bean requires proxying (e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.getInvocationErrorMessage(targetBean, msg, args));
        }
    }

    private String getInvocationErrorMessage(Object bean, String message, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(bean, message));
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append('[').append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }

    private static class ReactiveDelegate {
        private ReactiveDelegate() {
        }

        public static boolean subscribeToPublisher(ApplicationListenerMethodAdapter listener, Object result) {
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(result.getClass());
            if (adapter != null) {
                adapter.toPublisher(result).subscribe((Subscriber)new EventPublicationSubscriber(listener));
                return true;
            }
            return false;
        }
    }

    private record EventPublicationSubscriber(ApplicationListenerMethodAdapter listener) implements Subscriber<Object>
    {
        public void onSubscribe(Subscription s) {
            s.request(Integer.MAX_VALUE);
        }

        public void onNext(Object o) {
            this.listener.publishEvents(o);
        }

        public void onError(Throwable t) {
            this.listener.handleAsyncError(t);
        }

        public void onComplete() {
        }
    }
}

