/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.event.ApplicationEventMulticaster;
import cn.taketoday.context.event.GenericApplicationListener;
import cn.taketoday.context.event.GenericApplicationListenerAdapter;
import cn.taketoday.context.event.SmartApplicationListener;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public abstract class AbstractApplicationEventMulticaster
implements ApplicationEventMulticaster,
BeanClassLoaderAware,
BeanFactoryAware {
    private final DefaultListenerRetriever listenerRetriever = new DefaultListenerRetriever();
    final ConcurrentHashMap<ListenerCacheKey, CachedListenerRetriever> retrieverCache = new ConcurrentHashMap(64);
    @Nullable
    private ClassLoader beanClassLoader;
    @Nullable
    private ConfigurableBeanFactory beanFactory;

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        if (this.beanClassLoader == null) {
            this.beanClassLoader = this.beanFactory.getBeanClassLoader();
        }
    }

    private ConfigurableBeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("ApplicationEventMulticaster cannot retrieve listener beans because it is not associated with a BeanFactory");
        }
        return this.beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            Object singletonTarget = AopProxyUtils.getSingletonTarget((Object)listener);
            if (singletonTarget instanceof ApplicationListener) {
                this.listenerRetriever.applicationListeners.remove(singletonTarget);
            }
            this.listenerRetriever.applicationListeners.add(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListenerBean(String listenerBeanName) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListenerBeans.add(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(ApplicationListener<?> listener) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListeners.remove(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListenerBean(String listenerBeanName) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListenerBeans.remove(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListeners(Predicate<ApplicationListener<?>> predicate) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListeners.removeIf(predicate);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListenerBeans(Predicate<String> predicate) {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListenerBeans.removeIf(predicate);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            this.listenerRetriever.applicationListeners.clear();
            this.listenerRetriever.applicationListenerBeans.clear();
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener<?>> getApplicationListeners() {
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            return this.listenerRetriever.getApplicationListeners();
        }
    }

    protected Collection<ApplicationListener<?>> getApplicationListeners(ApplicationEvent event, ResolvableType eventType) {
        Collection<ApplicationListener<?>> result;
        Object source = event.getSource();
        Class<?> sourceType = source != null ? source.getClass() : null;
        ListenerCacheKey cacheKey = new ListenerCacheKey(eventType, sourceType);
        CachedListenerRetriever newRetriever = null;
        CachedListenerRetriever existingRetriever = this.retrieverCache.get(cacheKey);
        if (existingRetriever == null && (this.beanClassLoader == null || ClassUtils.isCacheSafe(event.getClass(), (ClassLoader)this.beanClassLoader) && (sourceType == null || ClassUtils.isCacheSafe(sourceType, (ClassLoader)this.beanClassLoader))) && (existingRetriever = this.retrieverCache.putIfAbsent(cacheKey, newRetriever = new CachedListenerRetriever())) != null) {
            newRetriever = null;
        }
        if (existingRetriever != null && (result = existingRetriever.getApplicationListeners()) != null) {
            return result;
        }
        return this.retrieveApplicationListeners(eventType, sourceType, newRetriever);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ApplicationListener<?>> retrieveApplicationListeners(ResolvableType eventType, @Nullable Class<?> sourceType, @Nullable CachedListenerRetriever retriever) {
        LinkedHashSet<String> listenerBeans;
        LinkedHashSet listeners;
        ArrayList allListeners = new ArrayList();
        LinkedHashSet filteredListeners = retriever != null ? new LinkedHashSet() : null;
        LinkedHashSet<String> filteredListenerBeans = retriever != null ? new LinkedHashSet<String>() : null;
        DefaultListenerRetriever defaultListenerRetriever = this.listenerRetriever;
        synchronized (defaultListenerRetriever) {
            listeners = new LinkedHashSet(this.listenerRetriever.applicationListeners);
            listenerBeans = new LinkedHashSet<String>(this.listenerRetriever.applicationListenerBeans);
        }
        for (ApplicationListener applicationListener : listeners) {
            if (!this.supportsEvent(applicationListener, eventType, sourceType)) continue;
            if (retriever != null) {
                filteredListeners.add(applicationListener);
            }
            allListeners.add(applicationListener);
        }
        if (!listenerBeans.isEmpty()) {
            ConfigurableBeanFactory beanFactory = this.getBeanFactory();
            for (String listenerBeanName : listenerBeans) {
                try {
                    Object listener;
                    if (this.supportsEvent(beanFactory, listenerBeanName, eventType)) {
                        listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                        if (allListeners.contains(listener) || !this.supportsEvent((ApplicationListener<?>)listener, eventType, sourceType)) continue;
                        if (retriever != null) {
                            if (beanFactory.isSingleton(listenerBeanName)) {
                                filteredListeners.add((ApplicationListener<?>)listener);
                            } else {
                                filteredListenerBeans.add(listenerBeanName);
                            }
                        }
                        allListeners.add((ApplicationListener<?>)listener);
                        continue;
                    }
                    listener = beanFactory.getSingleton(listenerBeanName);
                    if (retriever != null) {
                        filteredListeners.remove(listener);
                    }
                    allListeners.remove(listener);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
            }
        }
        AnnotationAwareOrderComparator.sort(allListeners);
        if (retriever != null) {
            retriever.applicationListeners = filteredListenerBeans.isEmpty() ? new LinkedHashSet(allListeners) : filteredListeners;
            retriever.applicationListenerBeans = filteredListenerBeans;
        }
        return allListeners;
    }

    private boolean supportsEvent(ConfigurableBeanFactory beanFactory, String listenerBeanName, ResolvableType eventType) {
        Class listenerType = beanFactory.getType(listenerBeanName);
        if (listenerType == null || GenericApplicationListener.class.isAssignableFrom(listenerType) || SmartApplicationListener.class.isAssignableFrom(listenerType)) {
            return true;
        }
        if (!this.supportsEvent(listenerType, eventType)) {
            return false;
        }
        try {
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(listenerBeanName);
            ResolvableType genericEventType = bd.getResolvableType().as(ApplicationListener.class).getGeneric(new int[0]);
            return genericEventType == ResolvableType.NONE || genericEventType.isAssignableFrom(eventType);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return true;
        }
    }

    protected boolean supportsEvent(Class<?> listenerType, ResolvableType eventType) {
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listenerType);
        return declaredEventType == null || declaredEventType.isAssignableFrom(eventType);
    }

    protected boolean supportsEvent(ApplicationListener<?> listener, ResolvableType eventType, @Nullable Class<?> sourceType) {
        GenericApplicationListener smartListener = listener instanceof GenericApplicationListener ? (GenericApplicationListener)listener : new GenericApplicationListenerAdapter(listener);
        return smartListener.supportsEventType(eventType) && smartListener.supportsSourceType(sourceType);
    }

    private class DefaultListenerRetriever {
        public final LinkedHashSet<String> applicationListenerBeans = new LinkedHashSet();
        public final LinkedHashSet<ApplicationListener<?>> applicationListeners = new LinkedHashSet();

        private DefaultListenerRetriever() {
        }

        public Collection<ApplicationListener<?>> getApplicationListeners() {
            ArrayList allListeners = new ArrayList(this.applicationListeners.size() + this.applicationListenerBeans.size());
            allListeners.addAll(this.applicationListeners);
            if (!this.applicationListenerBeans.isEmpty()) {
                ConfigurableBeanFactory beanFactory = AbstractApplicationEventMulticaster.this.getBeanFactory();
                for (String listenerBeanName : this.applicationListenerBeans) {
                    try {
                        ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                        if (allListeners.contains(listener)) continue;
                        allListeners.add(listener);
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
                }
            }
            AnnotationAwareOrderComparator.sort(allListeners);
            return allListeners;
        }
    }

    private record ListenerCacheKey(ResolvableType eventType, @Nullable Class<?> sourceType) implements Comparable<ListenerCacheKey>
    {
        private ListenerCacheKey {
            Assert.notNull((Object)eventType, (String)"Event type must not be null");
        }

        @Override
        public int compareTo(ListenerCacheKey other) {
            int result = this.eventType.toString().compareTo(other.eventType.toString());
            if (result == 0) {
                if (this.sourceType == null) {
                    return other.sourceType == null ? 0 : -1;
                }
                if (other.sourceType == null) {
                    return 1;
                }
                result = this.sourceType.getName().compareTo(other.sourceType.getName());
            }
            return result;
        }
    }

    private class CachedListenerRetriever {
        @Nullable
        public volatile Set<String> applicationListenerBeans;
        @Nullable
        public volatile Set<ApplicationListener<?>> applicationListeners;

        private CachedListenerRetriever() {
        }

        @Nullable
        public Collection<ApplicationListener<?>> getApplicationListeners() {
            Set<ApplicationListener<?>> applicationListeners = this.applicationListeners;
            Set<String> applicationListenerBeans = this.applicationListenerBeans;
            if (applicationListeners == null || applicationListenerBeans == null) {
                return null;
            }
            ArrayList allListeners = new ArrayList(applicationListeners.size() + applicationListenerBeans.size());
            allListeners.addAll(applicationListeners);
            if (!applicationListenerBeans.isEmpty()) {
                ConfigurableBeanFactory beanFactory = AbstractApplicationEventMulticaster.this.getBeanFactory();
                for (String listenerBeanName : applicationListenerBeans) {
                    try {
                        allListeners.add((ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class));
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
                }
            }
            if (!applicationListenerBeans.isEmpty()) {
                AnnotationAwareOrderComparator.sort(allListeners);
            }
            return allListeners;
        }
    }
}

