/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.config;

import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.xml.AbstractBeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import cn.taketoday.jmx.support.MBeanServerFactoryBean;
import cn.taketoday.util.StringUtils;
import org.w3c.dom.Element;

class MBeanServerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_SERVER_BEAN_NAME = "mbeanServer";
    private static final String AGENT_ID_ATTRIBUTE = "agent-id";

    MBeanServerBeanDefinitionParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = element.getAttribute("id");
        return StringUtils.hasText((String)id) ? id : MBEAN_SERVER_BEAN_NAME;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String agentId = element.getAttribute(AGENT_ID_ATTRIBUTE);
        if (StringUtils.hasText((String)agentId)) {
            RootBeanDefinition bd = new RootBeanDefinition(MBeanServerFactoryBean.class);
            bd.getPropertyValues().add("agentId", (Object)agentId);
            return bd;
        }
        RootBeanDefinition bd = new RootBeanDefinition(MBeanServerFactoryBean.class);
        bd.getPropertyValues().add("locateExistingServerIfPossible", (Object)Boolean.TRUE);
        bd.setRole(2);
        bd.setSource(parserContext.extractSource((Object)element));
        return bd;
    }
}

