/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.config;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.parsing.BeanComponentDefinition;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

class LoadTimeWeaverBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String ASPECTJ_WEAVING_ENABLER_BEAN_NAME = "cn.taketoday.context.config.internalAspectJWeavingEnabler";
    private static final String ASPECTJ_WEAVING_ENABLER_CLASS_NAME = "cn.taketoday.context.weaving.AspectJWeavingEnabler";
    private static final String DEFAULT_LOAD_TIME_WEAVER_CLASS_NAME = "cn.taketoday.context.weaving.DefaultContextLoadTimeWeaver";
    private static final String WEAVER_CLASS_ATTRIBUTE = "weaver-class";
    private static final String ASPECTJ_WEAVING_ATTRIBUTE = "aspectj-weaving";

    LoadTimeWeaverBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        if (element.hasAttribute(WEAVER_CLASS_ATTRIBUTE)) {
            return element.getAttribute(WEAVER_CLASS_ATTRIBUTE);
        }
        return DEFAULT_LOAD_TIME_WEAVER_CLASS_NAME;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return "loadTimeWeaver";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setRole(2);
        if (this.isAspectJWeavingEnabled(element.getAttribute(ASPECTJ_WEAVING_ATTRIBUTE), parserContext) && !parserContext.getRegistry().containsBeanDefinition(ASPECTJ_WEAVING_ENABLER_BEAN_NAME)) {
            RootBeanDefinition def = new RootBeanDefinition(ASPECTJ_WEAVING_ENABLER_CLASS_NAME);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, ASPECTJ_WEAVING_ENABLER_BEAN_NAME));
        }
    }

    protected boolean isAspectJWeavingEnabled(String value, ParserContext parserContext) {
        if ("on".equals(value)) {
            return true;
        }
        if ("off".equals(value)) {
            return false;
        }
        ClassLoader cl = parserContext.getReaderContext().getBeanClassLoader();
        return cl != null && cl.getResource("META-INF/aop.xml") != null;
    }
}

