/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.ConditionalOnResource;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.MultiValueMap;
import java.util.ArrayList;
import java.util.List;

final class OnResourceCondition
extends InfraCondition {
    OnResourceCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnResource.class.getName(), true);
        ResourceLoader loader = context.getResourceLoader();
        ArrayList<String> locations = new ArrayList<String>();
        this.collectValues(locations, (List)attributes.get((Object)"value"));
        Assert.isTrue((!locations.isEmpty() ? 1 : 0) != 0, (String)"@ConditionalOnResource annotations must specify at least one resource location");
        ArrayList<String> missing = new ArrayList<String>();
        for (String location : locations) {
            String resource = context.getEnvironment().resolvePlaceholders(location);
            if (loader.getResource(resource).exists()) continue;
            missing.add(location);
        }
        if (!missing.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).didNotFind("resource", "resources").items(ConditionMessage.Style.QUOTE, missing));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).found("location", "locations").items(locations));
    }

    private void collectValues(List<String> names, List<Object> values) {
        for (Object value : values) {
            for (Object item : (Object[])value) {
                names.add((String)item);
            }
        }
    }
}

