/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.context.properties.bind.BindResult;
import cn.taketoday.context.properties.bind.Bindable;
import cn.taketoday.context.properties.bind.Binder;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import java.util.List;
import java.util.function.Supplier;

public class OnPropertyListCondition
extends InfraCondition {
    private static final Bindable<List<String>> STRING_LIST = Bindable.listOf(String.class);
    private final String propertyName;
    private final Supplier<ConditionMessage.Builder> messageBuilder;

    protected OnPropertyListCondition(String propertyName, Supplier<ConditionMessage.Builder> messageBuilder) {
        this.propertyName = propertyName;
        this.messageBuilder = messageBuilder;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BindResult<List<String>> property = Binder.get(context.getEnvironment()).bind(this.propertyName, STRING_LIST);
        ConditionMessage.Builder messageBuilder = this.messageBuilder.get();
        if (property.isBound()) {
            return ConditionOutcome.match(messageBuilder.found("property").items(this.propertyName));
        }
        return ConditionOutcome.noMatch(messageBuilder.didNotFind("property").items(this.propertyName));
    }
}

