/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.ConditionalOnProperty;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotationPredicates;
import cn.taketoday.core.env.PropertyResolver;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class OnPropertyCondition
extends InfraCondition
implements Ordered {
    OnPropertyCondition() {
    }

    public int getOrder() {
        return -2147483608;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<AnnotationAttributes> allAnnotationAttributes = metadata.getAnnotations().stream(ConditionalOnProperty.class).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(rec$ -> ((MergedAnnotation)rec$).asAnnotationAttributes(new MergedAnnotation.Adapt[0])).toList();
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, (PropertyResolver)context.getEnvironment());
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match(ConditionMessage.of(match));
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList<String> missingProperties = new ArrayList<String>();
        ArrayList<String> nonMatchingProperties = new ArrayList<String>();
        spec.collectProperties(resolver, missingProperties, nonMatchingProperties);
        if (!missingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).didNotFind("property", "properties").items(ConditionMessage.Style.QUOTE, missingProperties));
        }
        if (!nonMatchingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).found("different value in property", "different value in properties").items(ConditionMessage.Style.QUOTE, nonMatchingProperties));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).because("matched"));
    }

    private static class Spec {
        private final String prefix;
        private final String[] names;
        private final String havingValue;
        private final boolean matchIfMissing;

        Spec(AnnotationAttributes annotationAttributes) {
            Object prefix = annotationAttributes.getString("prefix").trim();
            if (StringUtils.hasText((String)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            this.prefix = prefix;
            this.havingValue = annotationAttributes.getString("havingValue");
            this.names = this.getNames((Map<String, Object>)annotationAttributes);
            this.matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        }

        private String[] getNames(Map<String, Object> annotationAttributes) {
            String[] value = (String[])annotationAttributes.get("value");
            String[] name = (String[])annotationAttributes.get("name");
            Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnProperty must be specified");
            Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnProperty are exclusive");
            return value.length > 0 ? value : name;
        }

        private void collectProperties(PropertyResolver resolver, List<String> missing, List<String> nonMatching) {
            for (String name : this.names) {
                String key = this.prefix + name;
                if (resolver.containsProperty(key)) {
                    if (this.isMatch(resolver.getProperty(key), this.havingValue)) continue;
                    nonMatching.add(name);
                    continue;
                }
                if (this.matchIfMissing) continue;
                missing.add(name);
            }
        }

        private boolean isMatch(String value, String requiredValue) {
            if (StringUtils.isNotEmpty((CharSequence)requiredValue)) {
                return requiredValue.equalsIgnoreCase(value);
            }
            return !"false".equalsIgnoreCase(value);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            result.append(this.prefix);
            if (this.names.length == 1) {
                result.append(this.names[0]);
            } else {
                result.append("[");
                result.append(StringUtils.arrayToCommaDelimitedString((Object[])this.names));
                result.append("]");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.havingValue)) {
                result.append("=").append(this.havingValue);
            }
            result.append(")");
            return result.toString();
        }
    }
}

