/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.ConditionalOnJndi;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.jndi.JndiLocatorDelegate;
import cn.taketoday.jndi.JndiLocatorSupport;
import cn.taketoday.util.StringUtils;
import javax.naming.NamingException;

class OnJndiCondition
extends InfraCondition
implements Ordered {
    OnJndiCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation annotation = metadata.getAnnotation(ConditionalOnJndi.class);
        String[] locations = annotation.getStringValueArray();
        try {
            return this.getMatchOutcome(locations);
        }
        catch (NoClassDefFoundError ex) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnJndi.class, new Object[0]).because("JNDI class not found"));
        }
    }

    private ConditionOutcome getMatchOutcome(String[] locations) {
        if (!this.isJndiAvailable()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnJndi.class, new Object[0]).notAvailable("JNDI environment"));
        }
        if (locations.length == 0) {
            return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnJndi.class, new Object[0]).available("JNDI environment"));
        }
        JndiLocator locator = this.getJndiLocator(locations);
        String location = locator.lookupFirstLocation();
        String details = "(" + StringUtils.arrayToCommaDelimitedString((Object[])locations) + ")";
        if (location != null) {
            return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnJndi.class, details).foundExactly("\"" + location + "\""));
        }
        return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnJndi.class, details).didNotFind("any matching JNDI location").atAll());
    }

    protected boolean isJndiAvailable() {
        return JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable();
    }

    protected JndiLocator getJndiLocator(String[] locations) {
        return new JndiLocator(locations);
    }

    public int getOrder() {
        return 2147483627;
    }

    protected static class JndiLocator
    extends JndiLocatorSupport {
        private final String[] locations;

        public JndiLocator(String[] locations) {
            this.locations = locations;
        }

        public String lookupFirstLocation() {
            for (String location : this.locations) {
                try {
                    this.lookup(location);
                    return location;
                }
                catch (NamingException namingException) {
                }
            }
            return null;
        }
    }
}

