/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.beans.factory.config.BeanExpressionContext;
import cn.taketoday.beans.factory.config.BeanExpressionResolver;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.ConditionalOnExpression;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.context.expression.StandardBeanExpressionResolver;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.type.AnnotatedTypeMetadata;

final class OnExpressionCondition
extends InfraCondition
implements Ordered {
    OnExpressionCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String expression = metadata.getAnnotation(ConditionalOnExpression.class).getStringValue();
        expression = this.wrapIfNecessary(expression);
        ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition(ConditionalOnExpression.class, "(" + expression + ")");
        expression = context.getEnvironment().resolvePlaceholders(expression);
        ConfigurableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory != null) {
            boolean result = this.evaluateExpression(beanFactory, expression);
            return new ConditionOutcome(result, messageBuilder.resultedIn(result));
        }
        return ConditionOutcome.noMatch(messageBuilder.because("no BeanFactory available."));
    }

    private Boolean evaluateExpression(ConfigurableBeanFactory beanFactory, String expression) {
        BeanExpressionContext expressionContext;
        Object result;
        BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
        if (resolver == null) {
            resolver = new StandardBeanExpressionResolver();
        }
        return (result = resolver.evaluate(expression, expressionContext = new BeanExpressionContext(beanFactory, null))) != null && (Boolean)result != false;
    }

    private String wrapIfNecessary(String expression) {
        if (!expression.startsWith("#{")) {
            return "#{" + expression + "}";
        }
        return expression;
    }

    public int getOrder() {
        return 2147483627;
    }
}

