/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.context.annotation.config.AutoConfigurationImportFilter;
import cn.taketoday.context.annotation.config.AutoConfigurationMetadata;
import cn.taketoday.context.condition.ConditionEvaluationReport;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class FilteringInfraCondition
extends InfraCondition
implements AutoConfigurationImportFilter,
BeanFactoryAware,
BeanClassLoaderAware {
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected final ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionEvaluationReport report = ConditionEvaluationReport.find(this.beanFactory);
        ConditionOutcome[] outcomes = this.getOutcomes(autoConfigurationClasses, autoConfigurationMetadata);
        boolean[] match = new boolean[outcomes.length];
        for (int i = 0; i < outcomes.length; ++i) {
            boolean bl = match[i] = outcomes[i] == null || outcomes[i].isMatch();
            if (match[i] || outcomes[i] == null) continue;
            this.logOutcome(autoConfigurationClasses[i], outcomes[i]);
            if (report == null) continue;
            report.recordConditionEvaluation(autoConfigurationClasses[i], this, outcomes[i]);
        }
        return match;
    }

    protected abstract ConditionOutcome[] getOutcomes(String[] var1, AutoConfigurationMetadata var2);

    protected final List<String> filter(Collection<String> classNames, ClassNameFilter classNameFilter, ClassLoader classLoader) {
        if (CollectionUtils.isEmpty(classNames)) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>(classNames.size());
        for (String candidate : classNames) {
            if (!classNameFilter.matches(candidate, classLoader)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    protected static Class<?> resolve(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return Class.forName(className, false, classLoader);
        }
        return Class.forName(className);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum ClassNameFilter {
        PRESENT{

            @Override
            public boolean matches(String className, ClassLoader classLoader) {
                return 1.isPresent(className, classLoader);
            }
        }
        ,
        MISSING{

            @Override
            public boolean matches(String className, ClassLoader classLoader) {
                return !2.isPresent(className, classLoader);
            }
        };


        public abstract boolean matches(String var1, ClassLoader var2);

        public static boolean isPresent(String className, ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            try {
                FilteringInfraCondition.resolve(className, classLoader);
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }
}

