/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.annotation.Condition;
import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ConditionEvaluationReport {
    private static final String BEAN_NAME = "autoConfigurationReport";
    private static final AncestorsMatchedCondition ANCESTOR_CONDITION = new AncestorsMatchedCondition();
    private boolean addedAncestorOutcomes;
    private ConditionEvaluationReport parent;
    private final ArrayList<String> exclusions = new ArrayList();
    private final HashSet<String> unconditionalClasses = new HashSet();
    private final TreeMap<String, ConditionAndOutcomes> outcomes = new TreeMap();

    private ConditionEvaluationReport() {
    }

    public void recordConditionEvaluation(String source, Condition condition, ConditionOutcome outcome) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.notNull((Object)outcome, (String)"Outcome must not be null");
        this.unconditionalClasses.remove(source);
        ConditionAndOutcomes outcomes = this.outcomes.get(source);
        if (outcomes == null) {
            outcomes = new ConditionAndOutcomes();
            this.outcomes.put(source, outcomes);
        }
        outcomes.add(condition, outcome);
        this.addedAncestorOutcomes = false;
    }

    public void recordExclusions(Collection<String> exclusions) {
        Assert.notNull(exclusions, (String)"exclusions must not be null");
        this.exclusions.addAll(exclusions);
    }

    public void recordEvaluationCandidates(List<String> evaluationCandidates) {
        Assert.notNull(evaluationCandidates, (String)"evaluationCandidates must not be null");
        this.unconditionalClasses.addAll(evaluationCandidates);
    }

    public Map<String, ConditionAndOutcomes> getConditionAndOutcomesBySource() {
        if (!this.addedAncestorOutcomes) {
            for (Map.Entry<String, ConditionAndOutcomes> entry : this.outcomes.entrySet()) {
                String source = entry.getKey();
                ConditionAndOutcomes sourceOutcomes = entry.getValue();
                if (sourceOutcomes.isFullMatch()) continue;
                this.addNoMatchOutcomeToAncestors(source);
            }
            this.addedAncestorOutcomes = true;
        }
        return Collections.unmodifiableMap(this.outcomes);
    }

    private void addNoMatchOutcomeToAncestors(String source) {
        String prefix = source + "$";
        for (Map.Entry<String, ConditionAndOutcomes> entry : this.outcomes.entrySet()) {
            String candidateSource = entry.getKey();
            if (!candidateSource.startsWith(prefix)) continue;
            ConditionOutcome outcome = ConditionOutcome.noMatch(ConditionMessage.forCondition("Ancestor " + source, new Object[0]).because("did not match"));
            ConditionAndOutcomes sourceOutcomes = entry.getValue();
            sourceOutcomes.add(ANCESTOR_CONDITION, outcome);
        }
    }

    public List<String> getExclusions() {
        return Collections.unmodifiableList(this.exclusions);
    }

    public Set<String> getUnconditionalClasses() {
        HashSet<String> filtered = new HashSet<String>(this.unconditionalClasses);
        filtered.removeAll(this.exclusions);
        return Collections.unmodifiableSet(filtered);
    }

    public ConditionEvaluationReport getParent() {
        return this.parent;
    }

    @Nullable
    public static ConditionEvaluationReport find(@Nullable BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            return ConditionEvaluationReport.get((ConfigurableBeanFactory)beanFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConditionEvaluationReport get(ConfigurableBeanFactory beanFactory) {
        ConfigurableBeanFactory configurableBeanFactory = beanFactory;
        synchronized (configurableBeanFactory) {
            ConditionEvaluationReport report;
            if (beanFactory.containsSingleton(BEAN_NAME)) {
                report = (ConditionEvaluationReport)beanFactory.getBean(BEAN_NAME, ConditionEvaluationReport.class);
            } else {
                report = new ConditionEvaluationReport();
                beanFactory.registerSingleton(BEAN_NAME, (Object)report);
            }
            ConditionEvaluationReport.locateParent(beanFactory.getParentBeanFactory(), report);
            return report;
        }
    }

    private static void locateParent(BeanFactory beanFactory, ConditionEvaluationReport report) {
        if (beanFactory != null && report.parent == null && beanFactory.containsBean(BEAN_NAME)) {
            report.parent = (ConditionEvaluationReport)beanFactory.getBean(BEAN_NAME, ConditionEvaluationReport.class);
        }
    }

    public ConditionEvaluationReport getDelta(ConditionEvaluationReport previousReport) {
        ConditionEvaluationReport delta = new ConditionEvaluationReport();
        for (Map.Entry<String, ConditionAndOutcomes> entry : this.outcomes.entrySet()) {
            String source = entry.getKey();
            ConditionAndOutcomes sourceOutcomes = entry.getValue();
            ConditionAndOutcomes previous = previousReport.outcomes.get(source);
            if (previous != null && previous.isFullMatch() == sourceOutcomes.isFullMatch()) continue;
            for (ConditionAndOutcome conditionAndOutcome : sourceOutcomes) {
                delta.recordConditionEvaluation(source, conditionAndOutcome.getCondition(), conditionAndOutcome.getOutcome());
            }
        }
        ArrayList<String> newExclusions = new ArrayList<String>(this.exclusions);
        newExclusions.removeAll(previousReport.getExclusions());
        delta.recordExclusions(newExclusions);
        ArrayList<String> newUnconditionalClasses = new ArrayList<String>(this.unconditionalClasses);
        newUnconditionalClasses.removeAll(previousReport.unconditionalClasses);
        delta.unconditionalClasses.addAll(newUnconditionalClasses);
        return delta;
    }

    public static class ConditionAndOutcomes
    implements Iterable<ConditionAndOutcome> {
        private final LinkedHashSet<ConditionAndOutcome> outcomes = new LinkedHashSet();

        public void add(Condition condition, ConditionOutcome outcome) {
            this.outcomes.add(new ConditionAndOutcome(condition, outcome));
        }

        public boolean isFullMatch() {
            for (ConditionAndOutcome conditionAndOutcomes : this) {
                if (conditionAndOutcomes.getOutcome().isMatch()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<ConditionAndOutcome> iterator() {
            return Collections.unmodifiableSet(this.outcomes).iterator();
        }
    }

    private static class AncestorsMatchedCondition
    implements Condition {
        private AncestorsMatchedCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ConditionAndOutcome {
        private final Condition condition;
        private final ConditionOutcome outcome;

        public ConditionAndOutcome(Condition condition, ConditionOutcome outcome) {
            this.condition = condition;
            this.outcome = outcome;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public ConditionOutcome getOutcome() {
            return this.outcome;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConditionAndOutcome other = (ConditionAndOutcome)obj;
            return ObjectUtils.nullSafeEquals(this.condition.getClass(), other.condition.getClass()) && ObjectUtils.nullSafeEquals((Object)this.outcome, (Object)other.outcome);
        }

        public int hashCode() {
            return this.condition.getClass().hashCode() * 31 + this.outcome.hashCode();
        }

        public String toString() {
            return this.condition.getClass() + " " + this.outcome;
        }
    }
}

