/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.context.condition.AbstractNestedCondition;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import java.util.ArrayList;
import java.util.List;

public abstract class AllNestedConditions
extends AbstractNestedCondition {
    public AllNestedConditions(ConfigurationCondition.ConfigurationPhase configurationPhase) {
        super(configurationPhase);
    }

    @Override
    protected ConditionOutcome getFinalMatchOutcome(AbstractNestedCondition.MemberMatchOutcomes memberOutcomes) {
        boolean match = this.hasSameSize(memberOutcomes.matches, memberOutcomes.all);
        ArrayList<ConditionMessage> messages = new ArrayList<ConditionMessage>();
        messages.add(ConditionMessage.forCondition("AllNestedConditions", new Object[0]).because(memberOutcomes.matches.size() + " matched " + memberOutcomes.nonMatches.size() + " did not"));
        for (ConditionOutcome outcome : memberOutcomes.all) {
            messages.add(outcome.getConditionMessage());
        }
        return new ConditionOutcome(match, ConditionMessage.of(messages));
    }

    private boolean hasSameSize(List<?> list1, List<?> list2) {
        return list1.size() == list2.size();
    }
}

