/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.condition;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.context.annotation.Condition;
import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.annotation.Conditional;
import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.context.condition.ConditionMessage;
import cn.taketoday.context.condition.ConditionOutcome;
import cn.taketoday.context.condition.InfraCondition;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.classreading.SimpleMetadataReaderFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.DefaultMultiValueMap;
import cn.taketoday.util.MultiValueMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractNestedCondition
extends InfraCondition
implements ConfigurationCondition {
    private final ConfigurationCondition.ConfigurationPhase configurationPhase;

    AbstractNestedCondition(ConfigurationCondition.ConfigurationPhase configurationPhase) {
        Assert.notNull((Object)((Object)configurationPhase), (String)"ConfigurationPhase must not be null");
        this.configurationPhase = configurationPhase;
    }

    @Override
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return this.configurationPhase;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String className = this.getClass().getName();
        MemberConditions memberConditions = new MemberConditions(context, this.configurationPhase, className);
        MemberMatchOutcomes memberOutcomes = new MemberMatchOutcomes(memberConditions);
        return this.getFinalMatchOutcome(memberOutcomes);
    }

    protected abstract ConditionOutcome getFinalMatchOutcome(MemberMatchOutcomes var1);

    private static class MemberConditions {
        private final ConditionContext context;
        private final MetadataReaderFactory readerFactory;
        private final Map<AnnotationMetadata, List<Condition>> memberConditions;

        MemberConditions(ConditionContext context, ConfigurationCondition.ConfigurationPhase phase, String className) {
            this.context = context;
            this.readerFactory = new SimpleMetadataReaderFactory(context.getResourceLoader());
            String[] members = this.getMetadata(className).getMemberClassNames();
            this.memberConditions = this.getMemberConditions(members, phase, className);
        }

        private Map<AnnotationMetadata, List<Condition>> getMemberConditions(String[] members, ConfigurationCondition.ConfigurationPhase phase, String className) {
            DefaultMultiValueMap memberConditions = MultiValueMap.fromLinkedHashMap();
            for (String member : members) {
                AnnotationMetadata metadata = this.getMetadata(member);
                for (String[] conditionClasses : this.getConditionClasses((AnnotatedTypeMetadata)metadata)) {
                    for (String conditionClass : conditionClasses) {
                        Condition condition = this.getCondition(conditionClass);
                        this.validateMemberCondition(condition, phase, className);
                        memberConditions.add((Object)metadata, (Object)condition);
                    }
                }
            }
            return Collections.unmodifiableMap(memberConditions);
        }

        private void validateMemberCondition(Condition condition, ConfigurationCondition.ConfigurationPhase nestedPhase, String nestedClassName) {
            ConfigurationCondition ccd;
            ConfigurationCondition.ConfigurationPhase memberPhase;
            if (nestedPhase == ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION && condition instanceof ConfigurationCondition && (memberPhase = (ccd = (ConfigurationCondition)condition).getConfigurationPhase()) == ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN) {
                throw new IllegalStateException("Nested condition " + nestedClassName + " uses a configuration phase that is inappropriate for " + condition.getClass());
            }
        }

        private AnnotationMetadata getMetadata(String className) {
            try {
                return this.readerFactory.getMetadataReader(className).getAnnotationMetadata();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private List<String[]> getConditionClasses(AnnotatedTypeMetadata metadata) {
            Object values;
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(Conditional.class.getName(), true);
            if (attributes != null && (values = attributes.get((Object)"value")) != null) {
                return (List)values;
            }
            return Collections.emptyList();
        }

        private Condition getCondition(String className) {
            Class conditionClass = ClassUtils.resolveClassName((String)className, (ClassLoader)this.context.getClassLoader());
            return (Condition)BeanUtils.newInstance((Class)conditionClass);
        }

        List<ConditionOutcome> getMatchOutcomes() {
            ArrayList<ConditionOutcome> outcomes = new ArrayList<ConditionOutcome>();
            for (Map.Entry<AnnotationMetadata, List<Condition>> entry : this.memberConditions.entrySet()) {
                AnnotationMetadata metadata = entry.getKey();
                List<Condition> conditions = entry.getValue();
                outcomes.add(new MemberOutcomes(this.context, metadata, conditions).getUltimateOutcome());
            }
            return Collections.unmodifiableList(outcomes);
        }
    }

    protected static class MemberMatchOutcomes {
        public final List<ConditionOutcome> all;
        public final List<ConditionOutcome> matches;
        public final List<ConditionOutcome> nonMatches;

        public MemberMatchOutcomes(MemberConditions memberConditions) {
            this.all = memberConditions.getMatchOutcomes();
            ArrayList<ConditionOutcome> matches = new ArrayList<ConditionOutcome>();
            ArrayList nonMatches = new ArrayList();
            for (ConditionOutcome outcome : this.all) {
                (outcome.isMatch() ? matches : nonMatches).add(outcome);
            }
            this.matches = Collections.unmodifiableList(matches);
            this.nonMatches = Collections.unmodifiableList(nonMatches);
        }
    }

    private static class MemberOutcomes {
        private final AnnotationMetadata metadata;
        private final List<ConditionOutcome> outcomes;
        private final ConditionContext context;

        MemberOutcomes(ConditionContext context, AnnotationMetadata metadata, List<Condition> conditions) {
            this.context = context;
            this.metadata = metadata;
            this.outcomes = new ArrayList<ConditionOutcome>(conditions.size());
            for (Condition condition : conditions) {
                this.outcomes.add(this.getConditionOutcome(metadata, condition));
            }
        }

        private ConditionOutcome getConditionOutcome(AnnotationMetadata metadata, Condition condition) {
            if (condition instanceof InfraCondition) {
                return ((InfraCondition)condition).getMatchOutcome(this.context, (AnnotatedTypeMetadata)metadata);
            }
            return new ConditionOutcome(condition.matches(this.context, (AnnotatedTypeMetadata)metadata), ConditionMessage.empty());
        }

        ConditionOutcome getUltimateOutcome() {
            ConditionMessage.Builder message = ConditionMessage.forCondition("NestedCondition on " + ClassUtils.getShortName((String)this.metadata.getClassName()), new Object[0]);
            if (this.outcomes.size() == 1) {
                ConditionOutcome outcome = this.outcomes.get(0);
                return new ConditionOutcome(outcome.isMatch(), message.because(outcome.getMessage()));
            }
            ArrayList<ConditionOutcome> match = new ArrayList<ConditionOutcome>();
            ArrayList nonMatch = new ArrayList();
            for (ConditionOutcome outcome : this.outcomes) {
                (outcome.isMatch() ? match : nonMatch).add(outcome);
            }
            if (nonMatch.isEmpty()) {
                return ConditionOutcome.match(message.found("matching nested conditions").items(match));
            }
            return ConditionOutcome.noMatch(message.found("non-matching nested conditions").items(nonMatch));
        }
    }
}

