/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.TypeFilter;
import java.io.IOException;
import java.util.Collection;

public class TypeExcludeFilter
implements TypeFilter,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private Collection<TypeExcludeFilter> delegates;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory factory) throws IOException {
        if (this.beanFactory != null && this.getClass() == TypeExcludeFilter.class) {
            for (TypeExcludeFilter delegate : this.getDelegates()) {
                if (!delegate.match(metadataReader, factory)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<TypeExcludeFilter> getDelegates() {
        Collection<TypeExcludeFilter> delegates = this.delegates;
        if (delegates == null) {
            this.delegates = delegates = this.beanFactory.getBeansOfType(TypeExcludeFilter.class).values();
        }
        return delegates;
    }

    public boolean equals(Object obj) {
        throw new IllegalStateException("TypeExcludeFilter " + this.getClass() + " has not implemented equals");
    }

    public int hashCode() {
        throw new IllegalStateException("TypeExcludeFilter " + this.getClass() + " has not implemented hashCode");
    }
}

