/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.core.io.UrlResource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public final class ImportCandidates
implements Iterable<String> {
    private static final String LOCATION = "META-INF/config/%s.imports";
    private static final String COMMENT_START = "#";
    private final ArrayList<String> candidates;

    private ImportCandidates(ArrayList<String> candidates) {
        Assert.notNull(candidates, (String)"'candidates' is required");
        this.candidates = candidates;
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.candidates.iterator();
    }

    public ArrayList<String> getCandidates() {
        return this.candidates;
    }

    public static ImportCandidates load(Class<?> annotation, @Nullable ClassLoader classLoader) {
        Assert.notNull(annotation, (String)"'annotation' must not be null");
        ClassLoader classLoaderToUse = ImportCandidates.decideClassloader(classLoader);
        String location = String.format(LOCATION, annotation.getName());
        Enumeration<URL> urls = ImportCandidates.findUrlsInClasspath(classLoaderToUse, location);
        ArrayList<String> importCandidates = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            importCandidates.addAll(ImportCandidates.readCandidateConfigurations(url));
        }
        return new ImportCandidates(importCandidates);
    }

    private static ClassLoader decideClassloader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ImportCandidates.class.getClassLoader();
        }
        return classLoader;
    }

    private static Enumeration<URL> findUrlsInClasspath(ClassLoader classLoader, String location) {
        try {
            return classLoader.getResources(location);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to load configurations from location [" + location + "]", ex);
        }
    }

    private static List<String> readCandidateConfigurations(URL url) {
        ArrayList<String> arrayList;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new UrlResource(url).getInputStream(), StandardCharsets.UTF_8));
        try {
            String line;
            ArrayList<String> candidates = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                line = ImportCandidates.stripComment(line);
                if ((line = line.trim()).isEmpty()) continue;
                candidates.add(line);
            }
            arrayList = candidates;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to load configurations from location [" + url + "]", ex);
            }
        }
        reader.close();
        return arrayList;
    }

    private static String stripComment(String line) {
        int commentStart = line.indexOf(COMMENT_START);
        if (commentStart == -1) {
            return line;
        }
        return line.substring(0, commentStart);
    }
}

