/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.context.annotation.config.AutoConfigurationImportSelector;
import cn.taketoday.context.annotation.config.DeterminableImports;
import cn.taketoday.context.annotation.config.ImportAutoConfiguration;
import cn.taketoday.context.annotation.config.ImportCandidates;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.DefaultMultiValueMap;
import cn.taketoday.util.MultiValueMap;
import cn.taketoday.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImportAutoConfigurationImportSelector
extends AutoConfigurationImportSelector
implements DeterminableImports {
    @Override
    public Set<Object> determineImports(AnnotationMetadata metadata) {
        List<String> candidateConfigurations = this.getCandidateConfigurations(metadata, null);
        LinkedHashSet<String> result = new LinkedHashSet<String>(candidateConfigurations);
        result.removeAll(this.getExclusions(metadata, null));
        return Collections.unmodifiableSet(result);
    }

    @Override
    @Nullable
    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return null;
    }

    @Override
    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, @Nullable AnnotationAttributes attributes) {
        ArrayList<String> candidates = new ArrayList<String>();
        Map<Class<?>, List<Annotation>> annotations = this.getAnnotations(metadata);
        for (Map.Entry<Class<?>, List<Annotation>> entry : annotations.entrySet()) {
            Class<?> source = entry.getKey();
            List<Annotation> sourceAnnotations = entry.getValue();
            this.collectCandidateConfigurations(source, sourceAnnotations, candidates);
        }
        return candidates;
    }

    private void collectCandidateConfigurations(Class<?> source, List<Annotation> annotations, List<String> candidates) {
        for (Annotation annotation : annotations) {
            candidates.addAll(this.getConfigurationsForAnnotation(source, annotation));
        }
    }

    private Collection<String> getConfigurationsForAnnotation(Class<?> source, Annotation annotation) {
        String[] classes = MergedAnnotation.from((Annotation)annotation).getStringArray("classes");
        if (classes.length > 0) {
            return Arrays.asList(classes);
        }
        return this.getStrategiesNames(source);
    }

    protected Collection<String> getStrategiesNames(Class<?> source) {
        ClassLoader beanClassLoader = this.getBeanClassLoader();
        ArrayList<String> strategies = ImportCandidates.load(source, beanClassLoader).getCandidates();
        strategies.addAll(TodayStrategies.findNames((String)source.getName(), (ClassLoader)beanClassLoader));
        return strategies;
    }

    @Override
    protected Set<String> getExclusions(AnnotationMetadata metadata, @Nullable AnnotationAttributes attributes) {
        Class[] exclude;
        LinkedHashSet<String> exclusions = new LinkedHashSet<String>();
        Class source = ClassUtils.resolveClassName((String)metadata.getClassName(), null);
        MergedAnnotation merged = MergedAnnotations.from((AnnotatedElement)source).get(ImportAutoConfiguration.class);
        if (merged.isPresent() && (exclude = merged.getClassArray("exclude")) != null) {
            for (Class excludeClass : exclude) {
                exclusions.add(excludeClass.getName());
            }
        }
        for (List<Annotation> annotations : this.getAnnotations(metadata).values()) {
            for (Annotation annotation : annotations) {
                Object[] excludes = MergedAnnotation.from((Annotation)annotation).getStringArray("exclude");
                if (!ObjectUtils.isNotEmpty((Object[])excludes)) continue;
                CollectionUtils.addAll(exclusions, (Object[])excludes);
            }
        }
        exclusions.addAll(this.getExcludeAutoConfigurationsProperty());
        return exclusions;
    }

    protected final Map<Class<?>, List<Annotation>> getAnnotations(AnnotationMetadata metadata) {
        DefaultMultiValueMap annotations = MultiValueMap.fromLinkedHashMap();
        Class source = ClassUtils.resolveClassName((String)metadata.getClassName(), null);
        this.collectAnnotations(source, (MultiValueMap<Class<?>, Annotation>)annotations, new HashSet());
        return Collections.unmodifiableMap(annotations);
    }

    private void collectAnnotations(Class<?> source, MultiValueMap<Class<?>, Annotation> annotations, HashSet<Class<?>> seen) {
        if (source != null && seen.add(source)) {
            for (Annotation annotation : source.getDeclaredAnnotations()) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation)) continue;
                if (ImportAutoConfiguration.class == annotation.annotationType()) {
                    annotations.add(source, (Object)annotation);
                }
                this.collectAnnotations(annotation.annotationType(), annotations, seen);
            }
            this.collectAnnotations(source.getSuperclass(), annotations, seen);
        }
    }

    @Override
    public int getOrder() {
        return super.getOrder() - 1;
    }

    @Override
    protected void handleInvalidExcludes(List<String> invalidExcludes) {
    }
}

