/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.context.annotation.config.AutoConfigurationImportSelector;
import cn.taketoday.context.annotation.config.AutoConfigurationSorter;
import cn.taketoday.context.annotation.config.Configurations;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.classreading.SimpleMetadataReaderFactory;
import cn.taketoday.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class AutoConfigurations
extends Configurations
implements Ordered {
    private static final AutoConfigurationSorter SORTER = new AutoConfigurationSorter((MetadataReaderFactory)new SimpleMetadataReaderFactory(), null);
    private static final Ordered ORDER = new AutoConfigurationImportSelector();

    protected AutoConfigurations(Collection<Class<?>> classes) {
        super(classes);
    }

    @Override
    protected Collection<Class<?>> sort(Collection<Class<?>> classes) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> c : classes) {
            names.add(c.getName());
        }
        ArrayList<String> sorted = SORTER.getInPriorityOrder(names);
        ArrayList configClasses = new ArrayList();
        for (String className : sorted) {
            Class configClass = ClassUtils.resolveClassName((String)className, null);
            configClasses.add(configClass);
        }
        return configClasses;
    }

    public int getOrder() {
        return ORDER.getOrder();
    }

    @Override
    protected AutoConfigurations merge(Set<Class<?>> mergedClasses) {
        return new AutoConfigurations(mergedClasses);
    }

    public static AutoConfigurations of(Class<?> ... classes) {
        return new AutoConfigurations(Arrays.asList(classes));
    }
}

