/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.GenericBeanDefinition;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.context.annotation.config.AutoConfigurationPackage;
import cn.taketoday.context.annotation.config.DeterminableImports;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AutoConfigurationPackages {
    private static final Logger log = LoggerFactory.getLogger(AutoConfigurationPackages.class);
    private static final String BEAN_NAME = AutoConfigurationPackages.class.getName();

    public static boolean has(BeanFactory beanFactory) {
        return beanFactory.containsBean(BEAN_NAME) && !AutoConfigurationPackages.get(beanFactory).isEmpty();
    }

    public static List<String> get(BeanFactory beanFactory) {
        try {
            return ((BasePackages)beanFactory.getBean(BEAN_NAME, BasePackages.class)).get();
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("Unable to retrieve @EnableAutoConfiguration base packages");
        }
    }

    public static void register(BeanDefinitionRegistry registry, String ... packageNames) {
        if (registry.containsBeanDefinition(BEAN_NAME)) {
            BasePackagesBeanDefinition beanDefinition = (BasePackagesBeanDefinition)registry.getBeanDefinition(BEAN_NAME);
            beanDefinition.addBasePackages(packageNames);
        } else {
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)new BasePackagesBeanDefinition(packageNames));
        }
    }

    static final class BasePackages {
        private final List<String> packages;
        private boolean loggedBasePackageInfo;

        BasePackages(String ... names) {
            ArrayList<String> packages = new ArrayList<String>();
            for (String name : names) {
                if (!StringUtils.hasText((String)name)) continue;
                packages.add(name);
            }
            this.packages = packages;
        }

        List<String> get() {
            if (!this.loggedBasePackageInfo) {
                if (this.packages.isEmpty()) {
                    if (log.isWarnEnabled()) {
                        log.warn("@EnableAutoConfiguration was declared on a class in the default package. Automatic @Repository and @Entity scanning is not enabled.");
                    }
                } else if (log.isDebugEnabled()) {
                    String packageNames = StringUtils.collectionToCommaDelimitedString(this.packages);
                    log.debug("@EnableAutoConfiguration was declared on a class in the package '{}'. Automatic @Repository and @Entity scanning is enabled.", (Object)packageNames);
                }
                this.loggedBasePackageInfo = true;
            }
            return this.packages;
        }
    }

    static final class BasePackagesBeanDefinition
    extends GenericBeanDefinition {
        private final LinkedHashSet<String> basePackages = new LinkedHashSet();

        BasePackagesBeanDefinition(String ... basePackages) {
            this.setBeanClass(BasePackages.class);
            this.setRole(2);
            this.addBasePackages(basePackages);
        }

        public Supplier<?> getInstanceSupplier() {
            return () -> new BasePackages(StringUtils.toStringArray(this.basePackages));
        }

        private void addBasePackages(String[] additionalBasePackages) {
            CollectionUtils.addAll(this.basePackages, (Object[])additionalBasePackages);
        }
    }

    private static final class PackageImports {
        private final List<String> packageNames;

        PackageImports(AnnotationMetadata metadata) {
            MergedAnnotation annotation = metadata.getAnnotation(AutoConfigurationPackage.class);
            Assert.state((boolean)annotation.isPresent(), (String)"attributes error");
            ArrayList packageNames = CollectionUtils.newArrayList((Object[])annotation.getStringArray("basePackages"));
            for (Class basePackageClass : annotation.getClassArray("basePackageClasses")) {
                packageNames.add(basePackageClass.getPackage().getName());
            }
            if (packageNames.isEmpty()) {
                packageNames.add(ClassUtils.getPackageName((String)metadata.getClassName()));
            }
            this.packageNames = packageNames;
        }

        List<String> getPackageNames() {
            return this.packageNames;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.packageNames.equals(((PackageImports)obj).packageNames);
        }

        public int hashCode() {
            return this.packageNames.hashCode();
        }

        public String toString() {
            return "Package Imports " + this.packageNames;
        }
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar,
    DeterminableImports {
        Registrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata metadata, BootstrapContext context) {
            String[] packageNames = StringUtils.toStringArray(new PackageImports(metadata).getPackageNames());
            AutoConfigurationPackages.register(context.getRegistry(), packageNames);
        }

        @Override
        public Set<Object> determineImports(AnnotationMetadata metadata) {
            return Collections.singleton(new PackageImports(metadata));
        }
    }
}

