/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.core.io.PropertiesUtils;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.UrlResource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AutoConfigurationMetadata {
    protected static final String PATH = "META-INF/autoconfigure-metadata.properties";
    private final Properties properties;

    AutoConfigurationMetadata(Properties properties) {
        this.properties = properties;
    }

    public boolean wasProcessed(String className) {
        return this.properties.containsKey(className);
    }

    public Integer getInteger(String className, String key) {
        return this.getInteger(className, key, null);
    }

    public Integer getInteger(String className, String key, Integer defaultValue) {
        String value = this.get(className, key);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public Set<String> getSet(String className, String key) {
        return this.getSet(className, key, null);
    }

    public Set<String> getSet(String className, String key, Set<String> defaultValue) {
        String value = this.get(className, key);
        return value != null ? StringUtils.commaDelimitedListToSet((String)value) : defaultValue;
    }

    public String get(String className, String key) {
        return this.get(className, key, null);
    }

    public String get(String className, String key, String defaultValue) {
        String value = this.properties.getProperty(className + "." + key);
        return value != null ? value : defaultValue;
    }

    public static AutoConfigurationMetadata load(@Nullable ClassLoader classLoader) {
        return AutoConfigurationMetadata.load(classLoader, PATH);
    }

    public static AutoConfigurationMetadata load(@Nullable ClassLoader classLoader, String path) {
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(path) : ClassLoader.getSystemResources(path);
            Properties properties = new Properties();
            while (urls.hasMoreElements()) {
                properties.putAll((Map<?, ?>)PropertiesUtils.loadProperties((Resource)new UrlResource(urls.nextElement())));
            }
            return AutoConfigurationMetadata.valueOf(properties);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load @ConditionalOnClass location [" + path + "]", ex);
        }
    }

    public static AutoConfigurationMetadata valueOf(Properties properties) {
        return new AutoConfigurationMetadata(properties);
    }
}

