/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.Aware;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.EnvironmentAware;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.context.annotation.DeferredImportSelector;
import cn.taketoday.context.annotation.config.AutoConfiguration;
import cn.taketoday.context.annotation.config.AutoConfigurationImportEvent;
import cn.taketoday.context.annotation.config.AutoConfigurationImportFilter;
import cn.taketoday.context.annotation.config.AutoConfigurationImportListener;
import cn.taketoday.context.annotation.config.AutoConfigurationMetadata;
import cn.taketoday.context.annotation.config.AutoConfigurationSorter;
import cn.taketoday.context.annotation.config.EnableAutoConfiguration;
import cn.taketoday.context.annotation.config.ImportCandidates;
import cn.taketoday.context.properties.bind.Binder;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class AutoConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware,
ResourceLoaderAware,
BeanFactoryAware,
EnvironmentAware,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(AutoConfigurationImportSelector.class);
    private static final String PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE = "context.autoconfigure.exclude";
    private ConfigurableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader beanClassLoader;
    private ResourceLoader resourceLoader;
    private ConfigurationClassFilter configurationClassFilter;

    @Override
    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        if (this.isEnabled(annotationMetadata)) {
            AutoConfigurationEntry autoConfigurationEntry = this.getAutoConfigurationEntry(annotationMetadata);
            return StringUtils.toStringArray(autoConfigurationEntry.configurations);
        }
        return NO_IMPORTS;
    }

    @Override
    public Predicate<String> getExclusionFilter() {
        return this::shouldExclude;
    }

    private boolean shouldExclude(String configurationClassName) {
        return this.getConfigurationClassFilter().filter(Collections.singletonList(configurationClassName)).isEmpty();
    }

    protected AutoConfigurationEntry getAutoConfigurationEntry(AnnotationMetadata annotationMetadata) {
        if (this.isEnabled(annotationMetadata)) {
            AnnotationAttributes attributes = this.getAttributes(annotationMetadata);
            List<String> configurations = this.getCandidateConfigurations(annotationMetadata, attributes);
            configurations = this.removeDuplicates(configurations);
            Set<String> exclusions = this.getExclusions(annotationMetadata, attributes);
            this.checkExcludedClasses(configurations, exclusions);
            configurations.removeAll(exclusions);
            configurations = this.getConfigurationClassFilter().filter(configurations);
            this.fireAutoConfigurationImportEvents(configurations, exclusions);
            return new AutoConfigurationEntry(configurations, exclusions);
        }
        return AutoConfigurationEntry.empty();
    }

    @Override
    public Class<? extends DeferredImportSelector.Group> getImportGroup() {
        return AutoConfigurationGroup.class;
    }

    protected boolean isEnabled(AnnotationMetadata metadata) {
        if (this.getClass() == AutoConfigurationImportSelector.class) {
            return (Boolean)this.getEnvironment().getProperty("enable-autoconfiguration", Boolean.class, (Object)true);
        }
        return true;
    }

    @Nullable
    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        String name = this.getAnnotationClass().getName();
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(name, true));
        if (attributes == null) {
            throw new IllegalArgumentException("No auto-configuration attributes found. Is " + metadata.getClassName() + " annotated with " + ClassUtils.getShortName((String)name) + "?");
        }
        return attributes;
    }

    protected Class<?> getAnnotationClass() {
        return EnableAutoConfiguration.class;
    }

    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, @Nullable AnnotationAttributes attributes) {
        ArrayList<String> configurations = ImportCandidates.load(AutoConfiguration.class, this.getBeanClassLoader()).getCandidates();
        configurations.addAll(TodayStrategies.findNames(this.getStrategyClass(), (ClassLoader)this.getBeanClassLoader()));
        Assert.notEmpty(configurations, (String)"No auto configuration classes found in META-INF/today-strategies.properties nor in META-INF/config/cn.taketoday.context.annotation.config.AutoConfiguration.imports. If you are using a custom packaging, make sure that file is correct.");
        return configurations;
    }

    protected Class<?> getStrategyClass() {
        return EnableAutoConfiguration.class;
    }

    private void checkExcludedClasses(List<String> configurations, Set<String> exclusions) {
        ArrayList<String> invalidExcludes = new ArrayList<String>(exclusions.size());
        for (String exclusion : exclusions) {
            if (!ClassUtils.isPresent((String)exclusion, (ClassLoader)this.getClass().getClassLoader()) || configurations.contains(exclusion)) continue;
            invalidExcludes.add(exclusion);
        }
        if (!invalidExcludes.isEmpty()) {
            this.handleInvalidExcludes(invalidExcludes);
        }
    }

    protected void handleInvalidExcludes(List<String> invalidExcludes) {
        StringBuilder message = new StringBuilder();
        for (String exclude : invalidExcludes) {
            message.append("\t- ").append(exclude).append(String.format("%n", new Object[0]));
        }
        throw new IllegalStateException(String.format("The following classes could not be excluded because they are not auto-configuration classes:%n%s", message));
    }

    protected Set<String> getExclusions(AnnotationMetadata metadata, @Nullable AnnotationAttributes attributes) {
        LinkedHashSet<String> excluded = new LinkedHashSet<String>();
        excluded.addAll(this.asList(attributes, "exclude"));
        excluded.addAll(this.asList(attributes, "excludeName"));
        excluded.addAll(this.getExcludeAutoConfigurationsProperty());
        return excluded;
    }

    protected List<String> getExcludeAutoConfigurationsProperty() {
        Environment environment = this.getEnvironment();
        if (environment == null) {
            return Collections.emptyList();
        }
        if (environment instanceof ConfigurableEnvironment) {
            Binder binder = Binder.get(environment);
            return binder.bind(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, String[].class).map(Arrays::asList).orElse(Collections.emptyList());
        }
        String[] excludes = (String[])environment.getProperty(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, String[].class);
        return excludes != null ? Arrays.asList(excludes) : Collections.emptyList();
    }

    protected List<AutoConfigurationImportFilter> getAutoConfigurationImportFilters() {
        return TodayStrategies.find(AutoConfigurationImportFilter.class, (ClassLoader)this.beanClassLoader);
    }

    private ConfigurationClassFilter getConfigurationClassFilter() {
        if (this.configurationClassFilter == null) {
            List<AutoConfigurationImportFilter> filters = this.getAutoConfigurationImportFilters();
            for (AutoConfigurationImportFilter filter : filters) {
                this.invokeAwareMethods(filter);
            }
            this.configurationClassFilter = new ConfigurationClassFilter(this.beanClassLoader, filters);
        }
        return this.configurationClassFilter;
    }

    protected final <T> List<T> removeDuplicates(List<T> list) {
        return new ArrayList<T>(new LinkedHashSet<T>(list));
    }

    protected final List<String> asList(AnnotationAttributes attributes, String name) {
        String[] value = attributes.getStringArray(name);
        return Arrays.asList(value);
    }

    private void fireAutoConfigurationImportEvents(List<String> configurations, Set<String> exclusions) {
        List<AutoConfigurationImportListener> listeners = this.getAutoConfigurationImportListeners();
        if (!listeners.isEmpty()) {
            AutoConfigurationImportEvent event = new AutoConfigurationImportEvent(this, configurations, exclusions);
            for (AutoConfigurationImportListener listener : listeners) {
                this.invokeAwareMethods(listener);
                listener.onAutoConfigurationImportEvent(event);
            }
        }
    }

    protected List<AutoConfigurationImportListener> getAutoConfigurationImportListeners() {
        return TodayStrategies.find(AutoConfigurationImportListener.class, (ClassLoader)this.beanClassLoader);
    }

    private void invokeAwareMethods(Object instance) {
        if (instance instanceof Aware) {
            if (instance instanceof BeanClassLoaderAware) {
                ((BeanClassLoaderAware)instance).setBeanClassLoader(this.beanClassLoader);
            }
            if (instance instanceof BeanFactoryAware) {
                ((BeanFactoryAware)instance).setBeanFactory((BeanFactory)this.beanFactory);
            }
            if (instance instanceof EnvironmentAware) {
                ((EnvironmentAware)instance).setEnvironment(this.environment);
            }
            if (instance instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)instance).setResourceLoader(this.resourceLoader);
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    protected final ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    protected static class AutoConfigurationEntry {
        public final Set<String> exclusions;
        public final List<String> configurations;

        AutoConfigurationEntry(Collection<String> configurations, Collection<String> exclusions) {
            this.configurations = new ArrayList<String>(configurations);
            this.exclusions = new HashSet<String>(exclusions);
        }

        public List<String> getConfigurations() {
            return this.configurations;
        }

        public Set<String> getExclusions() {
            return this.exclusions;
        }

        static AutoConfigurationEntry empty() {
            return new AutoConfigurationEntry(Collections.emptyList(), Collections.emptyList());
        }
    }

    private static class ConfigurationClassFilter {
        private final List<AutoConfigurationImportFilter> filters;
        private final AutoConfigurationMetadata autoConfigurationMetadata;

        ConfigurationClassFilter(ClassLoader classLoader, List<AutoConfigurationImportFilter> filters) {
            this.autoConfigurationMetadata = AutoConfigurationMetadata.load(classLoader);
            this.filters = filters;
        }

        List<String> filter(List<String> configurations) {
            long startTime = System.nanoTime();
            String[] candidates = StringUtils.toStringArray(configurations);
            boolean skipped = false;
            for (AutoConfigurationImportFilter autoConfigurationImportFilter : this.filters) {
                boolean[] match = autoConfigurationImportFilter.match(candidates, this.autoConfigurationMetadata);
                for (int i = 0; i < match.length; ++i) {
                    if (match[i]) continue;
                    candidates[i] = null;
                    skipped = true;
                }
            }
            if (!skipped) {
                return configurations;
            }
            ArrayList<String> result = new ArrayList<String>(candidates.length);
            for (String candidate : candidates) {
                if (candidate == null) continue;
                result.add(candidate);
            }
            if (log.isTraceEnabled()) {
                int n = configurations.size() - result.size();
                log.trace("Filtered {} auto configuration class in {} ms", (Object)n, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            return result;
        }
    }

    private static class AutoConfigurationGroup
    implements DeferredImportSelector.Group,
    BeanClassLoaderAware,
    BeanFactoryAware {
        private BeanFactory beanFactory;
        private ClassLoader beanClassLoader;
        private AutoConfigurationMetadata autoConfigurationMetadata;
        private final LinkedHashMap<String, AnnotationMetadata> entries = new LinkedHashMap();
        private final ArrayList<AutoConfigurationEntry> autoConfigurationEntries = new ArrayList();

        private AutoConfigurationGroup() {
        }

        public void setBeanClassLoader(ClassLoader classLoader) {
            this.beanClassLoader = classLoader;
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public void process(AnnotationMetadata annotationMetadata, DeferredImportSelector selector) {
            if (selector instanceof AutoConfigurationImportSelector) {
                AutoConfigurationImportSelector autoConfigSelector = (AutoConfigurationImportSelector)selector;
                AutoConfigurationEntry entry = autoConfigSelector.getAutoConfigurationEntry(annotationMetadata);
                this.autoConfigurationEntries.add(entry);
                for (String importClassName : entry.configurations) {
                    this.entries.putIfAbsent(importClassName, annotationMetadata);
                }
            } else {
                throw new IllegalStateException(String.format("Only %s implementations are supported, got %s", AutoConfigurationImportSelector.class.getSimpleName(), selector.getClass().getName()));
            }
        }

        @Override
        public Iterable<DeferredImportSelector.Group.Entry> selectImports() {
            if (this.autoConfigurationEntries.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashSet<String> processedConfigurations = new LinkedHashSet<String>();
            for (AutoConfigurationEntry entry : this.autoConfigurationEntries) {
                processedConfigurations.addAll(entry.configurations);
            }
            for (AutoConfigurationEntry entry : this.autoConfigurationEntries) {
                processedConfigurations.removeAll(entry.exclusions);
            }
            List<String> sortedConfigurations = this.sortAutoConfigurations(processedConfigurations, this.getAutoConfigurationMetadata());
            ArrayList<DeferredImportSelector.Group.Entry> entries = new ArrayList<DeferredImportSelector.Group.Entry>(sortedConfigurations.size());
            for (String importClassName : sortedConfigurations) {
                DeferredImportSelector.Group.Entry entry = new DeferredImportSelector.Group.Entry(this.entries.get(importClassName), importClassName);
                entries.add(entry);
            }
            return entries;
        }

        private AutoConfigurationMetadata getAutoConfigurationMetadata() {
            if (this.autoConfigurationMetadata == null) {
                this.autoConfigurationMetadata = AutoConfigurationMetadata.load(this.beanClassLoader);
            }
            return this.autoConfigurationMetadata;
        }

        private List<String> sortAutoConfigurations(Set<String> configurations, AutoConfigurationMetadata autoConfigurationMetadata) {
            return new AutoConfigurationSorter(this.getMetadataReaderFactory(), autoConfigurationMetadata).getInPriorityOrder(configurations);
        }

        private MetadataReaderFactory getMetadataReaderFactory() {
            BootstrapContext context = BootstrapContext.from(this.beanFactory);
            return context.getMetadataReaderFactory();
        }
    }
}

