/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.config;

import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.config.AutoConfiguration;
import cn.taketoday.context.annotation.config.EnableAutoConfiguration;
import cn.taketoday.context.annotation.config.ImportCandidates;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.TodayStrategies;
import java.io.IOException;
import java.util.List;

public class AutoConfigurationExcludeFilter
implements TypeFilter,
BeanClassLoaderAware {
    private ClassLoader beanClassLoader;
    private volatile List<String> autoConfigurations;

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory factory) throws IOException {
        return this.isConfiguration(metadataReader) && this.isAutoConfiguration(metadataReader);
    }

    private boolean isConfiguration(MetadataReader metadataReader) {
        return metadataReader.getAnnotationMetadata().isAnnotated(Configuration.class.getName());
    }

    private boolean isAutoConfiguration(MetadataReader metadataReader) {
        return this.getAutoConfigurations().contains(metadataReader.getClassMetadata().getClassName());
    }

    protected List<String> getAutoConfigurations() {
        if (this.autoConfigurations == null) {
            this.autoConfigurations = ImportCandidates.load(AutoConfiguration.class, this.beanClassLoader).getCandidates();
            this.autoConfigurations.addAll(TodayStrategies.findNames(EnableAutoConfiguration.class, (ClassLoader)this.beanClassLoader));
        }
        return this.autoConfigurations;
    }
}

