/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ComponentScan;
import cn.taketoday.context.annotation.FilterType;
import cn.taketoday.context.annotation.ParserStrategyUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.filter.AnnotationTypeFilter;
import cn.taketoday.core.type.filter.AspectJTypeFilter;
import cn.taketoday.core.type.filter.AssignableTypeFilter;
import cn.taketoday.core.type.filter.RegexPatternTypeFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Assert;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class TypeFilterUtils {
    public static List<TypeFilter> createTypeFiltersFor(MergedAnnotation<ComponentScan.Filter> filterAnnotation, BootstrapContext loadingContext) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filterAnnotation.getEnum("type", FilterType.class);
        block9: for (Class filterClass : filterAnnotation.getClassValueArray()) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"@ComponentScan ANNOTATION type filter requires an annotation type");
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(filterClass));
                    continue block9;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block9;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"@ComponentScan CUSTOM type filter requires a TypeFilter implementation");
                    TypeFilter filter = ParserStrategyUtils.newInstance(filterClass, TypeFilter.class, loadingContext);
                    typeFilters.add(filter);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with Class value: " + filterType);
                }
            }
        }
        block10: for (String expression : filterAnnotation.getStringArray("pattern")) {
            switch (filterType) {
                case ASPECTJ: {
                    typeFilters.add((TypeFilter)new AspectJTypeFilter(expression, loadingContext.getClassLoader()));
                    continue block10;
                }
                case REGEX: {
                    typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(expression)));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with String pattern: " + filterType);
                }
            }
        }
        return typeFilters;
    }
}

