/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.BeanInstantiationException;
import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.factory.Aware;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.DependencyInjector;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.EnvironmentAware;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;

abstract class ParserStrategyUtils {
    ParserStrategyUtils() {
    }

    static <T> T newInstance(Class<?> clazz, Class<T> assignableTo, BootstrapContext loadingContext) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.isAssignable(assignableTo, clazz);
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        BeanDefinitionRegistry registry = loadingContext.getRegistry();
        PatternResourceLoader resourceLoader = loadingContext.getResourceLoader();
        Environment environment = loadingContext.getEnvironment();
        ClassLoader classLoader = registry instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)registry).getBeanClassLoader() : resourceLoader.getClassLoader();
        Object instance = ParserStrategyUtils.createInstance(clazz, environment, (ResourceLoader)resourceLoader, registry, classLoader);
        ParserStrategyUtils.invokeAwareMethods(instance, environment, (ResourceLoader)resourceLoader, registry, classLoader);
        return (T)instance;
    }

    private static Object createInstance(Class<?> clazz, Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length == 1 && constructors[0].getParameterCount() > 0) {
            try {
                Constructor<?> constructor = constructors[0];
                Object[] args = ParserStrategyUtils.resolveArgs(constructor, environment, resourceLoader, registry, classLoader);
                ReflectionUtils.makeAccessible(constructor);
                return BeanUtils.newInstance(constructor, (Object[])args);
            }
            catch (BeanInstantiationException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(clazz, "No suitable constructor found", (Throwable)ex);
            }
        }
        return BeanUtils.newInstance(clazz);
    }

    private static Object[] resolveArgs(Constructor<?> constructor, Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        int i = 0;
        Parameter[] parameters = constructor.getParameters();
        Object[] args = new Object[parameters.length];
        Object[] providedArgs = new Object[]{classLoader, environment, resourceLoader, registry};
        for (Parameter parameter : parameters) {
            Object arg = DependencyInjector.findProvided((Parameter)parameter, (Object[])providedArgs);
            if (arg == null) {
                throw new IllegalStateException("Illegal method parameter type: " + parameter.getType().getName());
            }
            args[i++] = arg;
        }
        return args;
    }

    private static void invokeAwareMethods(Object parserStrategyBean, Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        if (parserStrategyBean instanceof Aware) {
            if (parserStrategyBean instanceof BeanClassLoaderAware && classLoader != null) {
                ((BeanClassLoaderAware)parserStrategyBean).setBeanClassLoader(classLoader);
            }
            if (parserStrategyBean instanceof BeanFactoryAware && registry instanceof BeanFactory) {
                ((BeanFactoryAware)parserStrategyBean).setBeanFactory((BeanFactory)registry);
            }
            if (parserStrategyBean instanceof EnvironmentAware) {
                ((EnvironmentAware)parserStrategyBean).setEnvironment(environment);
            }
            if (parserStrategyBean instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)parserStrategyBean).setResourceLoader(resourceLoader);
            }
        }
    }
}

