/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.annotation.Autowired;
import cn.taketoday.context.annotation.Bean;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.EnableLoadTimeWeaving;
import cn.taketoday.context.annotation.ImportAware;
import cn.taketoday.context.annotation.LoadTimeWeavingConfigurer;
import cn.taketoday.context.annotation.Role;
import cn.taketoday.context.weaving.AspectJWeavingEnabler;
import cn.taketoday.context.weaving.DefaultContextLoadTimeWeaver;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    @Nullable
    private MergedAnnotation<EnableLoadTimeWeaving> enableLTW;
    @Nullable
    private LoadTimeWeavingConfigurer ltwConfigurer;
    @Nullable
    private ClassLoader beanClassLoader;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = importMetadata.getAnnotation(EnableLoadTimeWeaving.class);
        if (!this.enableLTW.isPresent()) {
            throw new IllegalArgumentException("@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    public void setLoadTimeWeavingConfigurer(LoadTimeWeavingConfigurer ltwConfigurer) {
        this.ltwConfigurer = ltwConfigurer;
    }

    public void setBeanClassLoader(@Nullable ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Role(value=2)
    @Bean(value={"loadTimeWeaver"})
    public LoadTimeWeaver loadTimeWeaver() {
        Assert.state((this.beanClassLoader != null ? 1 : 0) != 0, (String)"No ClassLoader set");
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        if (this.enableLTW != null) {
            EnableLoadTimeWeaving.AspectJWeaving aspectJWeaving = (EnableLoadTimeWeaving.AspectJWeaving)this.enableLTW.getEnum("aspectjWeaving", EnableLoadTimeWeaving.AspectJWeaving.class);
            switch (aspectJWeaving) {
                case DISABLED: {
                    break;
                }
                case AUTODETECT: {
                    if (this.beanClassLoader.getResource("META-INF/aop.xml") == null) break;
                    AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                    break;
                }
                case ENABLED: {
                    AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                }
            }
        }
        return loadTimeWeaver;
    }
}

