/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.context.annotation.ConfigurationClass;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.MultiValueMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

final class ImportRegistry
extends ArrayDeque<ConfigurationClass> {
    private final MultiValueMap<String, AnnotationMetadata> imports = MultiValueMap.fromLinkedHashMap();

    ImportRegistry() {
    }

    public void registerImport(AnnotationMetadata importingClass, String importedClass) {
        this.imports.add((Object)importedClass, (Object)importingClass);
    }

    @Nullable
    public AnnotationMetadata getImportingClassFor(String importedClass) {
        return (AnnotationMetadata)CollectionUtils.lastElement((List)((List)this.imports.get((Object)importedClass)));
    }

    public void removeImportingClass(String importingClass) {
        block0: for (List list : this.imports.values()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((AnnotationMetadata)iterator.next()).getClassName().equals(importingClass)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner("->", "[", "]");
        for (ConfigurationClass configurationClass : this) {
            joiner.add(configurationClass.getSimpleName());
        }
        return joiner.toString();
    }
}

